/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.functions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="CacheLearningTest")
public class CacheLearningTest {
    @Test
    public void howTo() throws ExecutionException {
        LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                if (key.equals("runtimeexception")) {
                    throw new RuntimeException("runtimeexception");
                }
                if (key.equals("exception")) {
                    throw new Exception("exception");
                }
                return key.equals("foo") ? null : key;
            }

            public String toString() {
                return "testLoader";
            }
        });
        try {
            cache.get((Object)"foo");
            Assert.fail((String)"expected exception on miss");
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"CacheLoader returned null for key foo.");
        }
        try {
            cache.getUnchecked((Object)"foo");
            Assert.fail((String)"expected exception on miss");
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"CacheLoader returned null for key foo.");
        }
        Assert.assertEquals((int)cache.asMap().keySet().size(), (int)0);
        Assert.assertEquals((int)cache.asMap().size(), (int)0);
        cache.asMap().put("foo", "bar");
        Assert.assertEquals((String)((String)cache.get((Object)"foo")), (String)"bar");
        Assert.assertEquals((int)cache.asMap().keySet().size(), (int)1);
        Assert.assertEquals((int)cache.asMap().size(), (int)1);
        cache.asMap().remove("foo");
        Assert.assertEquals((int)cache.asMap().keySet().size(), (int)0);
        Assert.assertEquals((int)cache.asMap().size(), (int)0);
        try {
            cache.get((Object)"exception");
            Assert.fail((String)"expected checked exception in loader to rethrow as ExecutionException");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"java.lang.Exception: exception");
        }
        try {
            cache.get((Object)"runtimeexception");
            Assert.fail((String)"expected unchecked exception in loader to rethrow as UncheckedExecutionException");
        }
        catch (UncheckedExecutionException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"java.lang.RuntimeException: runtimeexception");
        }
        try {
            cache.getUnchecked((Object)"exception");
            Assert.fail((String)"expected checked exception in loader to rethrow as UncheckedExecutionException, when getUnchecked called");
        }
        catch (UncheckedExecutionException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"java.lang.Exception: exception");
        }
        Assert.assertEquals((String)((String)cache.get((Object)"bar")), (String)"bar");
        Assert.assertEquals((String)((String)cache.get((Object)"baz")), (String)"baz");
        Assert.assertEquals((int)cache.asMap().size(), (int)2);
    }
}

