/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.http.UriTemplates;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class UriTemplatesTest {
    @DataProvider(name="strings")
    public Object[][] createData() {
        return new Object[][]{{"apples"}, {"sp ace"}, {"unic\u20aade"}, {"qu?stion"}};
    }

    @Test(dataProvider="strings")
    public void testExpandNotUrlEncoded(String val) {
        Assert.assertEquals((String)UriTemplates.expand((String)"/repos/{user}", (Map)ImmutableMap.of((Object)"user", (Object)val)), (String)("/repos/" + val));
    }

    public void testMultipleParams() {
        Assert.assertEquals((String)UriTemplates.expand((String)"/repos/{user}/{repo}", (Map)ImmutableMap.of((Object)"user", (Object)"unic\u20aade", (Object)"repo", (Object)"foo")), (String)"/repos/unic\u20aade/foo");
    }

    public void testParamKeyHyphen() {
        Assert.assertEquals((String)UriTemplates.expand((String)"/{user-dir}", (Map)ImmutableMap.of((Object)"user-dir", (Object)"foo")), (String)"/foo");
    }

    public void testMissingParamProceeds() {
        Assert.assertEquals((String)UriTemplates.expand((String)"/{user-dir}", (Map)ImmutableMap.of((Object)"user_dir", (Object)"foo")), (String)"/{user-dir}");
    }
}

