/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.internal.GsonWrapper;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class UnwrapFirstValueNamedTest {
    GsonWrapper json = (GsonWrapper)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(GsonWrapper.class);

    public void testParseNestedElements() throws IOException {
        String nested = "{ \"count\":1 ,\"event\" : [  {name:'GREETINGS',source:'guest'} ] }";
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("goodie").payload(Payloads.newPayload((Object)nested))).build();
        List val = (List)new ParseFirstJsonValueNamed(this.json, (TypeLiteral)new TypeLiteral<List<Event>>(){}, new String[]{"event"}).apply(response);
        Assert.assertEquals((String)val.toString(), (String)"[(name=GREETINGS, source=guest)]");
    }

    public void testParseNestedElementsButNothing() throws IOException {
        String nested = "{ \"count\":1 ,\"event\" : [  ] }";
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("goodie").payload(Payloads.newPayload((Object)nested))).build();
        List val = (List)new ParseFirstJsonValueNamed(this.json, (TypeLiteral)new TypeLiteral<List<Event>>(){}, new String[]{"event"}).apply(response);
        Assert.assertEquals((String)val.toString(), (String)"[]");
    }

    public void testParseNestedFurtherElements() throws IOException {
        String nestedFurther = "{ \"listaccountsresponse\" : { \"count\":1 ,\"event\" : [  {name:'GREETINGS',source:'guest'} ] } }";
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("goodie").payload(Payloads.newPayload((Object)nestedFurther))).build();
        List val = (List)new ParseFirstJsonValueNamed(this.json, (TypeLiteral)new TypeLiteral<List<Event>>(){}, new String[]{"event"}).apply(response);
        Assert.assertEquals((String)val.toString(), (String)"[(name=GREETINGS, source=guest)]");
    }

    public void testParseNestedFurtherElementsButNothing() throws IOException {
        String nestedFurther = "{ \"listaccountsresponse\" : { \"count\":1 ,\"event\" : [ ] } }";
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("goodie").payload(Payloads.newPayload((Object)nestedFurther))).build();
        List val = (List)new ParseFirstJsonValueNamed(this.json, (TypeLiteral)new TypeLiteral<List<Event>>(){}, new String[]{"event"}).apply(response);
        Assert.assertEquals((String)val.toString(), (String)"[]");
    }

    public void testParseNoPayloadEmptyList() throws IOException {
        HttpResponse response = HttpResponse.builder().statusCode(200).message("goodie").build();
        List val = (List)new ParseFirstJsonValueNamed(this.json, (TypeLiteral)new TypeLiteral<List<Event>>(){}, new String[]{"event"}).apply(response);
        Assert.assertEquals((Collection)val, (Collection)ImmutableList.of());
    }

    public void testParseNoPayloadEmptyMap() throws IOException {
        HttpResponse response = HttpResponse.builder().statusCode(200).message("goodie").build();
        Map val = (Map)new ParseFirstJsonValueNamed(this.json, (TypeLiteral)new TypeLiteral<Map<String, String>>(){}, new String[]{"event"}).apply(response);
        Assert.assertEquals((Map)val, (Map)ImmutableMap.of());
    }

    public void testParseNoPayloadEmptySet() throws IOException {
        HttpResponse response = HttpResponse.builder().statusCode(200).message("goodie").build();
        Set val = (Set)new ParseFirstJsonValueNamed(this.json, (TypeLiteral)new TypeLiteral<Set<Event>>(){}, new String[]{"event"}).apply(response);
        Assert.assertEquals((Set)val, (Set)ImmutableSet.of());
    }

    static class Event {
        private String name;
        private String source;

        private Event(String name, String source) {
            this.name = name;
            this.source = source;
        }

        public String toString() {
            return String.format("(name=%s, source=%s)", this.name, this.source);
        }
    }
}

