/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jclouds.ContextBuilder;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BackoffLimitedRetryHandlerTest")
public class BackoffLimitedRetryHandlerTest {
    BackoffLimitedRetryHandler handler = new BackoffLimitedRetryHandler();
    private final Function<Invocation, HttpRequest> processor = (Function)ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost")).buildInjector().getInstance(RestAnnotationProcessor.class);

    @Test
    void testExponentialBackoffDelayDefaultMaxInterval500() throws InterruptedException {
        long period = 500L;
        long acceptableDelay = period - 1L;
        long startTime = System.nanoTime();
        this.handler.imposeBackoffExponentialDelay(period, 2, 1, 5, "TEST FAILURE: 1");
        long elapsedTime = (System.nanoTime() - startTime) / 1000000L;
        assert (elapsedTime >= period - 1L) : elapsedTime;
        Assert.assertTrue((elapsedTime < period + acceptableDelay ? 1 : 0) != 0);
        startTime = System.nanoTime();
        this.handler.imposeBackoffExponentialDelay(period, 2, 2, 5, "TEST FAILURE: 2");
        elapsedTime = (System.nanoTime() - startTime) / 1000000L;
        assert (elapsedTime >= period * 4L - 1L) : elapsedTime;
        Assert.assertTrue((elapsedTime < period * 9L ? 1 : 0) != 0);
        startTime = System.nanoTime();
        this.handler.imposeBackoffExponentialDelay(period, 2, 3, 5, "TEST FAILURE: 3");
        elapsedTime = (System.nanoTime() - startTime) / 1000000L;
        assert (elapsedTime >= period * 9L - 1L) : elapsedTime;
        Assert.assertTrue((elapsedTime < period * 10L ? 1 : 0) != 0);
        startTime = System.nanoTime();
        this.handler.imposeBackoffExponentialDelay(period, 2, 4, 5, "TEST FAILURE: 4");
        elapsedTime = (System.nanoTime() - startTime) / 1000000L;
        assert (elapsedTime >= period * 10L - 1L) : elapsedTime;
        Assert.assertTrue((elapsedTime < period * 11L ? 1 : 0) != 0);
        startTime = System.nanoTime();
        this.handler.imposeBackoffExponentialDelay(period, 2, 5, 5, "TEST FAILURE: 5");
        elapsedTime = (System.nanoTime() - startTime) / 1000000L;
        assert (elapsedTime >= period * 10L - 1L) : elapsedTime;
        Assert.assertTrue((elapsedTime < period * 11L ? 1 : 0) != 0);
    }

    @Test
    void testClosesInputStream() throws InterruptedException, IOException, SecurityException, NoSuchMethodException {
        HttpCommand command = this.createCommand();
        HttpResponse response = HttpResponse.builder().statusCode(400).build();
        InputStream inputStream = new InputStream(){
            boolean isOpen = true;
            int count = 1;

            @Override
            public void close() {
                this.isOpen = false;
            }

            @Override
            public int read() throws IOException {
                if (this.isOpen) {
                    int n;
                    if (this.count > -1) {
                        int n2 = this.count;
                        n = n2;
                        this.count = n2 - 1;
                    } else {
                        n = -1;
                    }
                    return n;
                }
                return -1;
            }

            @Override
            public int available() throws IOException {
                if (this.isOpen) {
                    return this.count;
                }
                return 0;
            }
        };
        response.setPayload((Payload)Payloads.newInputStreamPayload((InputStream)inputStream));
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(1L));
        Assert.assertEquals((int)response.getPayload().getInput().available(), (int)1);
        Assert.assertEquals((int)response.getPayload().getInput().read(), (int)1);
        this.handler.shouldRetryRequest(command, response);
        Assert.assertEquals((int)response.getPayload().getInput().available(), (int)0);
        Assert.assertEquals((int)response.getPayload().getInput().read(), (int)-1);
    }

    private HttpCommand createCommand() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(IntegrationTestAsyncClient.class, (String)"download", (Class[])new Class[]{String.class});
        return new HttpCommand((HttpRequest)this.processor.apply((Object)Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1"))));
    }

    @Test
    void testIncrementsFailureCount() throws InterruptedException, IOException, SecurityException, NoSuchMethodException {
        HttpCommand command = this.createCommand();
        HttpResponse response = HttpResponse.builder().statusCode(400).build();
        this.handler.shouldRetryRequest(command, response);
        Assert.assertEquals((int)command.getFailureCount(), (int)1);
        this.handler.shouldRetryRequest(command, response);
        Assert.assertEquals((int)command.getFailureCount(), (int)2);
        this.handler.shouldRetryRequest(command, response);
        Assert.assertEquals((int)command.getFailureCount(), (int)3);
    }

    @Test
    void testDisallowsExcessiveRetries() throws InterruptedException, IOException, SecurityException, NoSuchMethodException {
        HttpCommand command = this.createCommand();
        HttpResponse response = HttpResponse.builder().statusCode(400).build();
        Assert.assertEquals((boolean)this.handler.shouldRetryRequest(command, response), (boolean)true);
        Assert.assertEquals((boolean)this.handler.shouldRetryRequest(command, response), (boolean)true);
        Assert.assertEquals((boolean)this.handler.shouldRetryRequest(command, response), (boolean)true);
        Assert.assertEquals((boolean)this.handler.shouldRetryRequest(command, response), (boolean)true);
        Assert.assertEquals((boolean)this.handler.shouldRetryRequest(command, response), (boolean)true);
        Assert.assertEquals((boolean)this.handler.shouldRetryRequest(command, response), (boolean)false);
    }
}

