/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class WireTest {
    public HttpWire setUp() throws Exception {
        BufferLogger bufferLogger = new BufferLogger();
        HttpWire wire = new HttpWire();
        wire.wireLog = bufferLogger;
        return wire;
    }

    public HttpWire setUpSynch() throws Exception {
        BufferLogger bufferLogger = new BufferLogger();
        HttpWire wire = new HttpWire();
        wire.wireLog = bufferLogger;
        return wire;
    }

    public void testInputInputStream() throws Exception {
        HttpWire wire = this.setUp();
        InputStream in = wire.input((InputStream)new ByteArrayInputStream("foo".getBytes()));
        String compare = Strings2.toStringAndClose((InputStream)in);
        Thread.sleep(100L);
        Assert.assertEquals((String)compare, (String)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)"<< \"foo\"");
    }

    public void testInputInputStreamSynch() throws Exception {
        HttpWire wire = this.setUpSynch();
        InputStream in = wire.input((InputStream)new ByteArrayInputStream("foo".getBytes()));
        String compare = Strings2.toStringAndClose((InputStream)in);
        Assert.assertEquals((String)compare, (String)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)"<< \"foo\"");
    }

    public void testOutputInputStream() throws Exception {
        HttpWire wire = this.setUp();
        InputStream in = (InputStream)wire.output((Object)new ByteArrayInputStream("foo".getBytes()));
        String compare = Strings2.toStringAndClose((InputStream)in);
        Thread.sleep(100L);
        Assert.assertEquals((String)compare, (String)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)">> \"foo\"");
    }

    public void testOutputBytes() throws Exception {
        HttpWire wire = this.setUp();
        wire.output((Object)"foo".getBytes());
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)">> \"foo\"");
    }

    public void testOutputString() throws Exception {
        HttpWire wire = this.setUp();
        wire.output((Object)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)">> \"foo\"");
    }

    class BufferLogger
    implements Logger {
        StringBuilder buff = new StringBuilder();

        BufferLogger() {
        }

        public void debug(String message, Object ... args) {
            this.buff.append(message);
        }

        public void error(String message, Object ... args) {
        }

        public void error(Throwable throwable, String message, Object ... args) {
        }

        public String getCategory() {
            return null;
        }

        public void info(String message, Object ... args) {
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void trace(String message, Object ... args) {
        }

        public void warn(String message, Object ... args) {
        }

        public void warn(Throwable throwable, String message, Object ... args) {
        }
    }
}

