/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Named;
import org.jclouds.internal.FilterStringsBoundToInjectorByName;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="FilterStringsBoundToInjectorByNameTest")
public class FilterStringsBoundToInjectorByNameTest {
    public void testEmptyWhenNoStringsBound() {
        FilterStringsBoundToInjectorByName fn = (FilterStringsBoundToInjectorByName)Guice.createInjector((Module[])new Module[0]).getInstance(FilterStringsBoundToInjectorByName.class);
        Assert.assertEquals((Map)fn.apply(Predicates.alwaysTrue()), (Map)ImmutableMap.of());
    }

    public void testEmptyWhenNotStringsBound() {
        FilterStringsBoundToInjectorByName fn = (FilterStringsBoundToInjectorByName)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"foo")).to(1L);
            }
        }}).getInstance(FilterStringsBoundToInjectorByName.class);
        Assert.assertEquals((Map)fn.apply(Predicates.alwaysTrue()), (Map)ImmutableMap.of());
    }

    public void testReturnsGuiceNamedString() {
        FilterStringsBoundToInjectorByName fn = (FilterStringsBoundToInjectorByName)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"foo")).to("bar");
            }
        }}).getInstance(FilterStringsBoundToInjectorByName.class);
        Assert.assertEquals((Map)fn.apply(Predicates.alwaysTrue()), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    public void testReturnsJavaNamedString() {
        FilterStringsBoundToInjectorByName fn = (FilterStringsBoundToInjectorByName)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @Named(value="foo")
            @Provides
            String provideFoo() {
                return "bar";
            }

            protected void configure() {
            }
        }}).getInstance(FilterStringsBoundToInjectorByName.class);
        Assert.assertEquals((Map)fn.apply(Predicates.alwaysTrue()), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    public void testFilterWorks() {
        FilterStringsBoundToInjectorByName fn = (FilterStringsBoundToInjectorByName)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"foo")).to("bar");
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"bing")).to("bong");
            }
        }}).getInstance(FilterStringsBoundToInjectorByName.class);
        Assert.assertEquals((Map)fn.apply(Predicates.equalTo((Object)"bing")), (Map)ImmutableMap.of((Object)"bing", (Object)"bong"));
    }
}

