/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.implicit;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.NoSuchElementException;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.implicit.FirstZone;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FirstZoneTest")
public class FirstZoneTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("servo").description("http://servo").build();
    Location region = new LocationBuilder().scope(LocationScope.REGION).id("servo-r").description("http://r.servo").parent(this.provider).build();
    Location zone = new LocationBuilder().scope(LocationScope.ZONE).id("servo-z").description("http://z.r.servo").parent(this.region).build();

    @Test
    public void testDidntFindZoneThrowsNSEEWithReasonableMessage() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region));
        FirstZone fn = new FirstZone(supplier);
        try {
            fn.get();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"none to of the locations are scope ZONE: [servo:PROVIDER, servo-r:REGION]");
        }
    }

    @Test
    public void testFirstZone() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region, (Object)this.zone));
        FirstZone fn = new FirstZone(supplier);
        Assert.assertEquals((Object)fn.get(), (Object)this.zone);
    }
}

