/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.osgi;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.apis.JcloudsTestComputeApiMetadata;
import org.jclouds.osgi.Bundles;
import org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata;
import org.jclouds.providers.JcloudsTestComputeProviderMetadata;
import org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.osgi.framework.Bundle;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BundlesTest {
    @Test
    public void testInstantiateAvailableClassesWhenAllAssignable() throws ClassNotFoundException {
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata")).andReturn(JcloudsTestBlobStoreProviderMetadata.class);
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestComputeProviderMetadata")).andReturn(JcloudsTestComputeProviderMetadata.class);
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata")).andReturn(JcloudsTestYetAnotherComputeProviderMetadata.class);
        EasyMock.replay((Object[])new Object[]{bundle});
        ImmutableSet providers = Bundles.instantiateAvailableClasses((Bundle)bundle, (Iterable)ImmutableSet.of((Object)"org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata", (Object)"org.jclouds.providers.JcloudsTestComputeProviderMetadata", (Object)"org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata"), ProviderMetadata.class);
        Assert.assertEquals((Iterable)providers, (Iterable)ImmutableSet.of((Object)((Object)new JcloudsTestBlobStoreProviderMetadata()), (Object)((Object)new JcloudsTestComputeProviderMetadata()), (Object)((Object)new JcloudsTestYetAnotherComputeProviderMetadata())));
        EasyMock.verify((Object[])new Object[]{bundle});
    }

    @Test
    public void testInstantiateAvailableClassesWhenNotAllAssignable() throws ClassNotFoundException {
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata")).andReturn(JcloudsTestBlobStoreProviderMetadata.class);
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestComputeApiMetadata")).andReturn(JcloudsTestComputeApiMetadata.class);
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata")).andReturn(JcloudsTestYetAnotherComputeProviderMetadata.class);
        EasyMock.replay((Object[])new Object[]{bundle});
        ImmutableSet providers = Bundles.instantiateAvailableClasses((Bundle)bundle, (Iterable)ImmutableSet.of((Object)"org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata", (Object)"org.jclouds.apis.JcloudsTestComputeApiMetadata", (Object)"org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata"), ProviderMetadata.class);
        Assert.assertEquals((Iterable)providers, (Iterable)ImmutableSet.of((Object)((Object)new JcloudsTestBlobStoreProviderMetadata()), (Object)((Object)new JcloudsTestYetAnotherComputeProviderMetadata())));
        EasyMock.verify((Object[])new Object[]{bundle});
    }

    @Test
    public void testStringsForResourcesInBundleWhenNoResources() throws Exception {
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.apis.ApiMetadata")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{bundle});
        Assert.assertEquals((Set)Bundles.stringsForResourceInBundle((String)"/META-INF/services/org.jclouds.apis.ApiMetadata", (Bundle)bundle), (Set)ImmutableSet.of());
        EasyMock.verify((Object[])new Object[]{bundle});
    }

    @Test
    public void testStringsForResourcesInBundleWhenResourcePresent() throws Exception {
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.providers.ProviderMetadata")).andReturn((Object)this.getClass().getResource("/META-INF/services/org.jclouds.providers.ProviderMetadata"));
        EasyMock.replay((Object[])new Object[]{bundle});
        Assert.assertEquals((Set)Bundles.stringsForResourceInBundle((String)"/META-INF/services/org.jclouds.providers.ProviderMetadata", (Bundle)bundle), (Set)ImmutableSet.of((Object)"org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata", (Object)"org.jclouds.providers.JcloudsTestComputeProviderMetadata", (Object)"org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata"));
        EasyMock.verify((Object[])new Object[]{bundle});
    }
}

