/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.jclouds.reflect.FunctionalReflection;
import org.jclouds.reflect.Invocation;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class FunctionalReflectionTest {
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testNullArgsAreAllowedAndUnmodifiable() {
        Function<Invocation, Object> test = new Function<Invocation, Object>(){

            public Object apply(Invocation e) {
                Assert.assertNotNull((Object)e.getArgs());
                Assert.assertNull(e.getArgs().get(0));
                e.getArgs().add("foo");
                throw new AssertionError((Object)"shouldn't be able to mutate the list!");
            }
        };
        ((Set)FunctionalReflection.newProxy(Set.class, (Function)test)).add(null);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testImmutableListWhenArgsAreNotNull() {
        Function<Invocation, Object> test = new Function<Invocation, Object>(){

            public Object apply(Invocation e) {
                Assert.assertNotNull((Object)e.getArgs());
                Assert.assertTrue((boolean)(e.getArgs() instanceof ImmutableList));
                Assert.assertEquals(e.getArgs().get(0), (Object)"foo");
                e.getArgs().add("bar");
                throw new AssertionError((Object)"shouldn't be able to mutate the list!");
            }
        };
        ((Set)FunctionalReflection.newProxy(Set.class, (Function)test)).add("foo");
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="io")
    public void testPropagatesDeclaredException() throws IOException {
        Function<Invocation, Object> test = new Function<Invocation, Object>(){

            public Object apply(Invocation e) {
                throw new RuntimeException(new IOException("io"));
            }
        };
        Closeable closeable = (Closeable)FunctionalReflection.newProxy(Closeable.class, (Function)test);
        closeable.close();
    }

    @Test(expectedExceptions={AssertionError.class}, expectedExceptionsMessageRegExp="assert")
    public void testPropagatesError() throws IOException {
        Function<Invocation, Object> test = new Function<Invocation, Object>(){

            public Object apply(Invocation e) {
                throw new AssertionError((Object)"assert");
            }
        };
        Closeable closeable = (Closeable)FunctionalReflection.newProxy(Closeable.class, (Function)test);
        closeable.close();
    }

    public void testToStringEqualsFunction() {
        Function<Invocation, Object> test = new Function<Invocation, Object>(){

            public Object apply(Invocation e) {
                return "foo";
            }

            public String toString() {
                return "bar";
            }
        };
        Closeable closeable = (Closeable)FunctionalReflection.newProxy(Closeable.class, (Function)test);
        Assert.assertEquals((String)closeable.toString(), (String)"bar");
    }

    public void testHashCodeDifferentiatesOnInterface() {
        Function<Invocation, Object> test = new Function<Invocation, Object>(){

            public Object apply(Invocation e) {
                return null;
            }

            public int hashCode() {
                return 1111;
            }
        };
        Appendable appendable1 = (Appendable)FunctionalReflection.newProxy(Appendable.class, (Function)test);
        Appendable appendable2 = (Appendable)FunctionalReflection.newProxy(Appendable.class, (Function)test);
        Assert.assertEquals((int)appendable1.hashCode(), (int)appendable2.hashCode());
        Closeable closeable = (Closeable)FunctionalReflection.newProxy(Closeable.class, (Function)test);
        Assert.assertNotEquals((Object)appendable1.hashCode(), (Object)closeable.hashCode());
    }
}

