/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.binders.BindException;
import org.jclouds.rest.binders.BindToXMLPayload;
import org.jclouds.xml.XMLParser;
import org.jclouds.xml.internal.JAXBParser;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindToXMLPayloadTest")
public class BindToXMLPayloadTest {
    XMLParser xml = new JAXBParser("true");

    @Test
    public void testBindJAXBObject() throws SecurityException, NoSuchMethodException {
        BindToXMLPayload binder = new BindToXMLPayload(this.xml);
        TestJAXBDomain obj = new TestJAXBDomain();
        obj.setElem("Hello World");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, (Object)obj);
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<test>\n    <elem>Hello World</elem>\n</test>\n");
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"application/xml");
    }

    @Test
    public void testHeaderIsChangedIfNeeded() throws SecurityException, NoSuchMethodException {
        BindToXMLPayload binder = new BindToXMLPayload(this.xml);
        TestJAXBDomain obj = new TestJAXBDomain();
        obj.setElem("Hello World");
        ImmutableMultimap headers = ImmutableMultimap.of((Object)"Content-type", (Object)"application/unknown");
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://momma").headers((Multimap)headers)).build();
        request = binder.bindToRequest(request, (Object)obj);
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<test>\n    <elem>Hello World</elem>\n</test>\n");
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"application/xml");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        BindToXMLPayload binder = new BindToXMLPayload(this.xml);
        binder.bindToRequest(HttpRequest.builder().method("GET").endpoint("http://momma").build(), null);
    }

    @Test(expectedExceptions={BindException.class})
    public void testInvalidObjectBinding() {
        BindToXMLPayload binder = new BindToXMLPayload(this.xml);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, new Object());
    }

    @XmlRootElement(name="test")
    public static class TestJAXBDomain {
        private String elem;

        public String getElem() {
            return this.elem;
        }

        public void setElem(String elem) {
            this.elem = elem;
        }
    }
}

