/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jclouds.concurrent.DynamicExecutors;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"performance"})
public abstract class PerformanceTest {
    protected static int LOOP_COUNT = 1000;
    protected static int THREAD_COUNT = 100;
    protected ExecutorService exec;

    @BeforeTest
    public void setupExecutorService() {
        this.exec = DynamicExecutors.newScalingThreadPool((int)1, (int)THREAD_COUNT, (long)1000L, (ThreadFactory)Executors.defaultThreadFactory());
    }

    @AfterTest
    public void teardownExecutorService() {
        this.exec.shutdownNow();
        this.exec = null;
    }

    protected void executeMultiThreadedPerformanceTest(String performanceTestName, List<Runnable> tasks) throws InterruptedException, ExecutionException, Throwable {
        ExecutorCompletionService<Throwable> completer = new ExecutorCompletionService<Throwable>(this.exec);
        final CountDownLatch startGate = new CountDownLatch(1);
        final CountDownLatch endGate = new CountDownLatch(THREAD_COUNT);
        for (int i = 0; i < THREAD_COUNT; ++i) {
            final Runnable task = tasks.get(i % tasks.size());
            completer.submit(new Callable<Throwable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Throwable call() {
                    try {
                        startGate.await();
                        task.run();
                        Throwable throwable = null;
                        return throwable;
                    }
                    catch (Throwable t) {
                        Throwable throwable = t;
                        return throwable;
                    }
                    finally {
                        endGate.countDown();
                    }
                }
            });
        }
        long startTime = System.nanoTime();
        startGate.countDown();
        endGate.await();
        long endTime = System.nanoTime() - startTime;
        for (int i = 0; i < THREAD_COUNT; ++i) {
            Throwable t = (Throwable)completer.take().get();
            if (t == null) continue;
            throw t;
        }
        if (performanceTestName != null) {
            System.out.printf("TIMING: Multi-threaded %s took %.3fms for %d threads\n", performanceTestName, (double)endTime / 1000000.0, THREAD_COUNT);
        }
    }

    protected void executeMultiThreadedCorrectnessTest(List<Runnable> tasks) throws InterruptedException, ExecutionException, Throwable {
        this.executeMultiThreadedPerformanceTest(null, tasks);
    }
}

