/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import com.squareup.okhttp.internal.SslContextBuilder;
import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.QueueDispatcher;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.jclouds.ContextBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.testng.annotations.BeforeClass;

public abstract class BaseMockWebServerTest {
    protected SSLContext sslContext;

    @BeforeClass(groups={"integration"})
    protected void setupSSL() {
        try {
            this.sslContext = new SslContextBuilder(InetAddress.getLocalHost().getHostName()).build();
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static MockWebServer mockWebServer(MockResponse ... responses) throws IOException {
        MockWebServer server = new MockWebServer();
        server.play();
        server.setDispatcher((Dispatcher)new GlobalChecksRequestDispatcher());
        for (MockResponse response : responses) {
            server.enqueue(response);
        }
        return server;
    }

    protected static MockWebServer mockWebServer(Dispatcher dispatcher) throws IOException {
        MockWebServer server = new MockWebServer();
        server.play();
        server.setDispatcher(dispatcher);
        return server;
    }

    protected <T extends Closeable> T api(Class<T> apiClass, String url) {
        Properties properties = new Properties();
        properties.setProperty("jclouds.trust-all-certs", "true");
        properties.setProperty("jclouds.relax-hostname", "true");
        this.addOverrideProperties(properties);
        return (T)ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forApiOnEndpoint(apiClass, (String)url)).modules((Iterable)ImmutableSet.of((Object)this.createConnectionModule())).overrides(properties).buildApi(apiClass);
    }

    protected abstract void addOverrideProperties(Properties var1);

    protected abstract Module createConnectionModule();

    protected static class GlobalChecksRequestDispatcher
    extends QueueDispatcher {
        protected GlobalChecksRequestDispatcher() {
        }

        public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
            MockResponse response = (MockResponse)this.responseQueue.take();
            if (!HttpRequest.NON_PAYLOAD_METHODS.contains(request.getMethod()) && request.getHeader("Content-Length") == null) {
                response.setResponseCode(500);
                response.setBody("No content length!");
            }
            return response;
        }
    }
}

