/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.utils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.http.utils.Queries;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="QueriesTest")
public class QueriesTest {
    public void testParseBase64InForm() {
        LinkedListMultimap expects = LinkedListMultimap.create();
        expects.put((Object)"Version", (Object)"2010-06-15");
        expects.put((Object)"Action", (Object)"ModifyInstanceAttribute");
        expects.put((Object)"Attribute", (Object)"userData");
        expects.put((Object)"Value", (Object)"dGVzdA==");
        expects.put((Object)"InstanceId", (Object)"1");
        Assert.assertEquals((Object)Queries.queryParser().apply((Object)"Version=2010-06-15&Action=ModifyInstanceAttribute&Attribute=userData&Value=dGVzdA%3D%3D&InstanceId=1"), (Object)expects);
    }

    @Test
    public void testParseQueryToMapSingleParam() {
        Multimap parsedMap = (Multimap)Queries.queryParser().apply((Object)"v=1.3");
        assert (parsedMap.keySet().size() == 1) : "Expected 1 key, found: " + parsedMap.keySet().size();
        assert (parsedMap.keySet().contains("v")) : "Expected v to be a part of the keys";
        String valueForV = (String)Iterables.getOnlyElement((Iterable)parsedMap.get((Object)"v"));
        assert (valueForV.equals("1.3")) : "Expected the value for 'v' to be '1.3', found: " + valueForV;
    }

    @Test
    public void testParseQueryToMapMultiParam() {
        Multimap parsedMap = (Multimap)Queries.queryParser().apply((Object)"v=1.3&sig=123");
        assert (parsedMap.keySet().size() == 2) : "Expected 2 keys, found: " + parsedMap.keySet().size();
        assert (parsedMap.keySet().contains("v")) : "Expected v to be a part of the keys";
        assert (parsedMap.keySet().contains("sig")) : "Expected sig to be a part of the keys";
        String valueForV = (String)Iterables.getOnlyElement((Iterable)parsedMap.get((Object)"v"));
        assert (valueForV.equals("1.3")) : "Expected the value for 'v' to be '1.3', found: " + valueForV;
        String valueForSig = (String)Iterables.getOnlyElement((Iterable)parsedMap.get((Object)"sig"));
        assert (valueForSig.equals("123")) : "Expected the value for 'v' to be '123', found: " + valueForSig;
    }

    @Test
    public void testParseQueryEncodedWithDefaultJavaEncoder() {
        String key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCc903twxU2zcQnIJdXv61RwZNZW94uId9qz08fgsBJsCOnHNIC4+L9kDOA2IHV9cUfEDBm1Be5TbpadWwSbS/05E+FARH2/MCO932UgcKUq5PGymS0249fLCBPci5zoLiG5vIym+1ij1hL/nHvkK99NIwe7io+Lmp9OcF3PTsm3Rgh5T09cRHGX9horp0VoAVa9vKJx6C1/IEHVnG8p0YPPa1lmemvx5kNBEiyoNQNYa34EiFkcJfP6rqNgvY8h/j4nE9SXoUCC/g6frhMFMOL0tzYqvz0Lczqm1Oh4RnSn3O9X4R934p28qqAobe337hmlLUdb6H5zuf+NwCh0HdZ";
        ImmutableSet expected = ImmutableSet.of((Object)key);
        Multimap parsedMap = (Multimap)Queries.queryParser().apply((Object)("a=1&b=1+2&publickey=" + Strings2.urlEncode((String)key, (char[])new char[0])));
        Assert.assertEquals((Collection)parsedMap.get((Object)"publickey"), (Collection)expected);
        parsedMap = (Multimap)Queries.queryParser().apply((Object)("publickey=" + Strings2.urlEncode((String)key, (char[])new char[0])));
        Assert.assertEquals((Collection)parsedMap.get((Object)"publickey"), (Collection)expected);
    }

    @Test
    public void testParseQueryWithKeysThatRequireDecoding() {
        Multimap parsedMap = (Multimap)Queries.queryParser().apply((Object)"network%5B0%5D.id=23&network%5B0%5D.address=192.168.0.1");
        Assert.assertEquals((Collection)parsedMap.get((Object)"network[0].id"), (Collection)ImmutableSet.of((Object)"23"));
        Assert.assertEquals((Collection)parsedMap.get((Object)"network[0].address"), (Collection)ImmutableSet.of((Object)"192.168.0.1"));
    }
}

