/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.utils;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class TestUtils {
    public static final Object[][] NO_INVOCATIONS = new Object[0][0];
    public static final Object[][] SINGLE_NO_ARG_INVOCATION = new Object[][]{new Object[0]};

    public static boolean isJava6() {
        System.out.println(System.getProperty("java.version", "None??"));
        return System.getProperty("java.version", "").contains("1.6.");
    }

    public static boolean isJava7() {
        System.out.println(System.getProperty("java.version", "None??"));
        return System.getProperty("java.version", "").contains("1.7.");
    }

    public static boolean isJava8() {
        System.out.println(System.getProperty("java.version", "None??"));
        return System.getProperty("java.version", "").contains("1.8.");
    }

    public static ByteSource randomByteSource() {
        return TestUtils.randomByteSource(0L);
    }

    public static ByteSource randomByteSource(long seed) {
        return new RandomByteSource(seed);
    }

    private static class RandomInputStream
    extends InputStream {
        private final Random random;

        RandomInputStream(long seed) {
            this.random = new Random(seed);
        }

        @Override
        public synchronized int read() {
            return (byte)this.random.nextInt();
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            this.random.nextBytes(b);
            return b.length;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            byte[] srcBytes = new byte[len];
            this.random.nextBytes(srcBytes);
            System.arraycopy(srcBytes, 0, b, off, len);
            return len;
        }
    }

    private static class RandomByteSource
    extends ByteSource {
        private final long seed;

        RandomByteSource(long seed) {
            this.seed = seed;
        }

        public InputStream openStream() {
            return new RandomInputStream(this.seed);
        }
    }
}

