/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.osgi;

import org.jclouds.osgi.ApiListener;
import org.jclouds.osgi.ApiRegistry;
import org.jclouds.osgi.MetadataBundleListener;
import org.jclouds.osgi.ProviderListener;
import org.jclouds.osgi.ProviderRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker providerListenerTracker = null;
    private ServiceTracker apiListenerTracker = null;
    private MetadataBundleListener bundleListener = new MetadataBundleListener();

    public void start(BundleContext context) throws Exception {
        this.bundleListener.start(context);
        this.providerListenerTracker = new ServiceTracker(context, ProviderListener.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object obj = super.addingService(reference);
                if (ProviderListener.class.isAssignableFrom(obj.getClass())) {
                    Activator.this.bundleListener.addProviderListener((ProviderListener)obj);
                }
                return obj;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (ProviderListener.class.isAssignableFrom(service.getClass())) {
                    Activator.this.bundleListener.removeProviderListener((ProviderListener)service);
                }
                super.removedService(reference, service);
            }
        };
        this.apiListenerTracker = new ServiceTracker(context, ApiListener.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object obj = super.addingService(reference);
                if (ApiListener.class.isAssignableFrom(obj.getClass())) {
                    Activator.this.bundleListener.addApiListenerListener((ApiListener)obj);
                }
                return obj;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (ApiListener.class.isAssignableFrom(service.getClass())) {
                    Activator.this.bundleListener.removeApiListenerListener((ApiListener)service);
                }
                super.removedService(reference, service);
            }
        };
        this.providerListenerTracker.open();
        this.apiListenerTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.bundleListener.stop(context);
        ProviderRegistry.clear();
        ApiRegistry.clear();
        if (this.apiListenerTracker != null) {
            this.apiListenerTracker.close();
        }
        if (this.providerListenerTracker != null) {
            this.providerListenerTracker.close();
        }
    }
}

