/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fallbacks;

import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateServiceDateCodecFactory;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.fallbacks.HeaderToRetryAfterException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.RetryAfterException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class HeaderToRetryAfterExceptionTest {
    public static HttpCommand command = new HttpCommand(HttpRequest.builder().method("GET").endpoint("http://stub").build());
    static DateCodec rfc822 = new DateServiceDateCodecFactory.DateServiceRfc822Codec((DateService)new SimpleDateFormatDateService());
    static Ticker y2k = new Ticker(){

        public long read() {
            return TimeUnit.MILLISECONDS.toNanos(rfc822.toDate("Sat, 1 Jan 2000 00:00:00 GMT").getTime());
        }
    };
    public static HeaderToRetryAfterException fn = HeaderToRetryAfterException.create((Ticker)y2k, (DateCodec)rfc822);

    @Test(expectedExceptions={RuntimeException.class})
    public void testArbitraryExceptionDoesntConvert() {
        fn.create((Throwable)new RuntimeException());
    }

    public void testHttpResponseExceptionWithoutResponseDoesntPropagate() {
        fn.create((Throwable)new HttpResponseException("message", command, null));
    }

    public void testHttpResponseExceptionWithoutRetryAfterHeaderDoesntPropagate() {
        fn.create((Throwable)new HttpResponseException(command, HttpResponse.builder().statusCode(500).build()));
    }

    public void testHttpResponseExceptionWithMalformedRetryAfterHeaderDoesntConvert() {
        fn.create((Throwable)new HttpResponseException(command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(503).addHeader("Retry-After", new String[]{"Fri, 31 Dec 1999 23:59:59 ZBW"})).build()));
    }

    @Test(expectedExceptions={RetryAfterException.class}, expectedExceptionsMessageRegExp="retry now")
    public void testHttpResponseExceptionWithRetryAfterDate() {
        fn.create((Throwable)new HttpResponseException(command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(503).addHeader("Retry-After", new String[]{"Fri, 31 Dec 1999 23:59:59 GMT"})).build()));
    }

    @Test(expectedExceptions={RetryAfterException.class}, expectedExceptionsMessageRegExp="retry in 700 seconds")
    public void testHttpResponseExceptionWithRetryAfterOffset() {
        fn.create((Throwable)new HttpResponseException(command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(503).addHeader("Retry-After", new String[]{"700"})).build()));
    }

    @Test(expectedExceptions={RetryAfterException.class}, expectedExceptionsMessageRegExp="retry in 86400 seconds")
    public void testHttpResponseExceptionWithRetryAfterPastIsZero() {
        fn.create((Throwable)new HttpResponseException(command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(503).addHeader("Retry-After", new String[]{"Sun, 2 Jan 2000 00:00:00 GMT"})).build()));
    }
}

