/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.json.internal.NullFilteringTypeAdapterFactories;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="NullFilteringTypeAdapterFactoriesTest")
public class NullFilteringTypeAdapterFactoriesTest {
    private Gson fluentIterable = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.FluentIterableTypeAdapterFactory()).create();
    private Type fluentIterableType = new TypeToken<FluentIterable<String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type fluentIterableResourceType = new TypeToken<FluentIterable<Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson collection = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.CollectionTypeAdapterFactory()).create();
    private Type collectionType = new TypeToken<Collection<String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type collectionResourceType = new TypeToken<Collection<Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson iterable = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.IterableTypeAdapterFactory()).create();
    private Type iterableType = new TypeToken<Iterable<String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type iterableResourceType = new TypeToken<Iterable<Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type iterableWildcardExtendsResourceType = new TypeToken<Iterable<? extends Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson list = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.ListTypeAdapterFactory()).create();
    private Type listType = new TypeToken<List<String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type listResourceType = new TypeToken<List<Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson immutableList = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.ImmutableListTypeAdapterFactory()).create();
    private Type immutableListType = new TypeToken<ImmutableList<String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type immutableListResourceType = new TypeToken<ImmutableList<Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson set = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.SetTypeAdapterFactory()).create();
    private Type setType = new TypeToken<Set<String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type setResourceType = new TypeToken<Set<Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson immutableSet = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.ImmutableSetTypeAdapterFactory()).create();
    private Type immutableSetType = new TypeToken<ImmutableSet<String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type immutableSetResourceType = new TypeToken<ImmutableSet<Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson immutableMap = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.ImmutableMapTypeAdapterFactory()).create();
    private Type immutableMapType = new TypeToken<ImmutableMap<String, String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type immutableMapResourceType = new TypeToken<ImmutableMap<String, Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson map = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.MapTypeAdapterFactory()).create();
    private Type mapType = new TypeToken<Map<String, String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type mapResourceType = new TypeToken<Map<String, Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Gson multimap = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new NullFilteringTypeAdapterFactories.MultimapTypeAdapterFactory()).create();
    private Type multimapType = new TypeToken<Multimap<String, String>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private Type multimapResourceType = new TypeToken<Multimap<String, Resource>>(){
        private static final long serialVersionUID = 1L;
    }.getType();

    public void testFluentIterable() {
        FluentIterable noNulls = (FluentIterable)this.fluentIterable.fromJson("[\"value\",\"a test string!\"]", this.fluentIterableType);
        Assert.assertEquals((Collection)noNulls.toList(), (Collection)ImmutableList.of((Object)"value", (Object)"a test string!"));
        FluentIterable withNull = (FluentIterable)this.fluentIterable.fromJson("[null,\"a test string!\"]", this.fluentIterableType);
        Assert.assertEquals((Collection)withNull.toList(), (Collection)ImmutableList.of((Object)"a test string!"));
        FluentIterable withDupes = (FluentIterable)this.fluentIterable.fromJson("[\"value\",\"value\"]", this.fluentIterableType);
        Assert.assertEquals((Collection)withDupes.toList(), (Collection)ImmutableList.of((Object)"value", (Object)"value"));
        FluentIterable resources = (FluentIterable)this.fluentIterable.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.fluentIterableResourceType);
        Assert.assertEquals((Collection)resources.toList(), (Collection)ImmutableList.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testCollection() {
        Collection noNulls = (Collection)this.collection.fromJson("[\"value\",\"a test string!\"]", this.collectionType);
        Assert.assertEquals((Collection)noNulls, (Collection)ImmutableList.of((Object)"value", (Object)"a test string!"));
        Collection withNull = (Collection)this.collection.fromJson("[null,\"a test string!\"]", this.collectionType);
        Assert.assertEquals((Collection)withNull, (Collection)ImmutableList.of((Object)"a test string!"));
        Collection withDupes = (Collection)this.collection.fromJson("[\"value\",\"value\"]", this.collectionType);
        Assert.assertEquals((Collection)withDupes, (Collection)ImmutableList.of((Object)"value", (Object)"value"));
        Collection resources = (Collection)this.collection.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.collectionResourceType);
        Assert.assertEquals((Collection)resources, (Collection)ImmutableList.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testIterable() {
        Iterable noNulls = (Iterable)this.iterable.fromJson("[\"value\",\"a test string!\"]", this.iterableType);
        Assert.assertEquals((Iterable)noNulls, (Iterable)ImmutableList.of((Object)"value", (Object)"a test string!"));
        Iterable withNull = (Iterable)this.iterable.fromJson("[null,\"a test string!\"]", this.iterableType);
        Assert.assertEquals((Iterable)withNull, (Iterable)ImmutableList.of((Object)"a test string!"));
        Iterable withDupes = (Iterable)this.iterable.fromJson("[\"value\",\"value\"]", this.iterableType);
        Assert.assertEquals((Iterable)withDupes, (Iterable)ImmutableList.of((Object)"value", (Object)"value"));
        Iterable resources = (Iterable)this.iterable.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.iterableResourceType);
        Assert.assertEquals((Iterable)resources, (Iterable)ImmutableList.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testWildcardExtends() {
        Iterable wildcardExtendsResources = (Iterable)this.iterable.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.iterableWildcardExtendsResourceType);
        Assert.assertEquals((Iterable)wildcardExtendsResources, (Iterable)ImmutableList.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testList() {
        Iterable noNulls = (Iterable)this.list.fromJson("[\"value\",\"a test string!\"]", this.listType);
        Assert.assertEquals((Iterable)noNulls, (Iterable)ImmutableList.of((Object)"value", (Object)"a test string!"));
        Iterable withNull = (Iterable)this.list.fromJson("[null,\"a test string!\"]", this.listType);
        Assert.assertEquals((Iterable)withNull, (Iterable)ImmutableList.of((Object)"a test string!"));
        Iterable withDupes = (Iterable)this.list.fromJson("[\"value\",\"value\"]", this.listType);
        Assert.assertEquals((Iterable)withDupes, (Iterable)ImmutableList.of((Object)"value", (Object)"value"));
        Iterable resources = (Iterable)this.list.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.listResourceType);
        Assert.assertEquals((Iterable)resources, (Iterable)ImmutableList.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testImmutableList() {
        Iterable noNulls = (Iterable)this.immutableList.fromJson("[\"value\",\"a test string!\"]", this.immutableListType);
        Assert.assertEquals((Iterable)noNulls, (Iterable)ImmutableList.of((Object)"value", (Object)"a test string!"));
        Iterable withNull = (Iterable)this.immutableList.fromJson("[null,\"a test string!\"]", this.immutableListType);
        Assert.assertEquals((Iterable)withNull, (Iterable)ImmutableList.of((Object)"a test string!"));
        Iterable withDupes = (Iterable)this.immutableList.fromJson("[\"value\",\"value\"]", this.immutableListType);
        Assert.assertEquals((Iterable)withDupes, (Iterable)ImmutableList.of((Object)"value", (Object)"value"));
        Iterable resources = (Iterable)this.immutableList.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.immutableListResourceType);
        Assert.assertEquals((Iterable)resources, (Iterable)ImmutableList.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testSet() {
        Set noNulls = (Set)this.set.fromJson("[\"value\",\"a test string!\"]", this.setType);
        Assert.assertEquals((Set)noNulls, (Set)ImmutableSet.of((Object)"value", (Object)"a test string!"));
        Set withNull = (Set)this.set.fromJson("[null,\"a test string!\"]", this.setType);
        Assert.assertEquals((Set)withNull, (Set)ImmutableSet.of((Object)"a test string!"));
        Set withDupes = (Set)this.set.fromJson("[\"value\",\"value\"]", this.setType);
        Assert.assertEquals((Set)withDupes, (Set)ImmutableSet.of((Object)"value"));
        Set resources = (Set)this.set.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.setResourceType);
        Assert.assertEquals((Set)resources, (Set)ImmutableSet.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testImmutableSet() {
        Iterable noNulls = (Iterable)this.immutableSet.fromJson("[\"value\",\"a test string!\"]", this.immutableSetType);
        Assert.assertEquals((Iterable)noNulls, (Iterable)ImmutableSet.of((Object)"value", (Object)"a test string!"));
        Iterable withNull = (Iterable)this.immutableSet.fromJson("[null,\"a test string!\"]", this.immutableSetType);
        Assert.assertEquals((Iterable)withNull, (Iterable)ImmutableSet.of((Object)"a test string!"));
        Iterable withDupes = (Iterable)this.immutableSet.fromJson("[\"value\",\"value\"]", this.immutableSetType);
        Assert.assertEquals((Iterable)withDupes, (Iterable)ImmutableSet.of((Object)"value", (Object)"value"));
        Iterable resources = (Iterable)this.immutableSet.fromJson("[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]", this.immutableSetResourceType);
        Assert.assertEquals((Iterable)resources, (Iterable)ImmutableSet.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    public void testImmutableMap() {
        ImmutableMap noNulls = (ImmutableMap)this.immutableMap.fromJson("{\"value\":\"a test string!\"}", this.immutableMapType);
        Assert.assertEquals((Map)noNulls, (Map)ImmutableMap.of((Object)"value", (Object)"a test string!"));
        ImmutableMap withNull = (ImmutableMap)this.immutableMap.fromJson("{\"key\":null}", this.immutableMapType);
        Assert.assertEquals((Map)withNull, (Map)ImmutableMap.of());
        ImmutableMap withEmpty = (ImmutableMap)this.map.fromJson("{\"value\":\"\"}", this.mapType);
        Assert.assertEquals((Map)withEmpty, (Map)ImmutableMap.of((Object)"value", (Object)""));
        ImmutableMap resources = (ImmutableMap)this.immutableMap.fromJson("{\"key1\":{\"id\":\"i-foo\",\"name\":\"foo\"},\"key2\":{\"id\":\"i-bar\",\"name\":\"bar\"}}", this.immutableMapResourceType);
        Assert.assertEquals((Map)resources, (Map)ImmutableMap.of((Object)"key1", (Object)new Resource("i-foo", "foo"), (Object)"key2", (Object)new Resource("i-bar", "bar")));
    }

    public void testMap() {
        Map noNulls = (Map)this.map.fromJson("{\"value\":\"a test string!\"}", this.mapType);
        Assert.assertEquals((Map)noNulls, (Map)ImmutableMap.of((Object)"value", (Object)"a test string!"));
        Map withNull = (Map)this.map.fromJson("{\"value\":null}", this.mapType);
        Assert.assertEquals((Map)withNull, (Map)ImmutableMap.of());
        Map withEmpty = (Map)this.map.fromJson("{\"value\":\"\"}", this.mapType);
        Assert.assertEquals((Map)withEmpty, (Map)ImmutableMap.of((Object)"value", (Object)""));
        Map resources = (Map)this.map.fromJson("{\"i-foo\":{\"id\":\"i-foo\",\"name\":\"foo\"},\"i-bar\":{\"id\":\"i-bar\",\"name\":\"bar\"}}", this.mapResourceType);
        Assert.assertEquals((Map)resources, (Map)ImmutableMap.of((Object)"i-foo", (Object)new Resource("i-foo", "foo"), (Object)"i-bar", (Object)new Resource("i-bar", "bar")));
    }

    public void testMultimap() {
        Multimap noNulls = (Multimap)this.multimap.fromJson("{\"value\":[\"a test string!\"]}", this.multimapType);
        Assert.assertEquals((Object)noNulls, (Object)ImmutableMultimap.of((Object)"value", (Object)"a test string!"));
        Multimap withNull = (Multimap)this.multimap.fromJson("{\"value\":[null]}", this.multimapType);
        Assert.assertEquals((Object)withNull, (Object)ImmutableMultimap.of());
        Multimap withEmpty = (Multimap)this.multimap.fromJson("{\"value\":[\"\"]}", this.multimapType);
        Assert.assertEquals((Object)withEmpty, (Object)ImmutableMultimap.of((Object)"value", (Object)""));
        Multimap withDupes = (Multimap)this.multimap.fromJson("{\"key\":[\"value\",\"value\"]}", this.multimapType);
        Assert.assertEquals((Collection)withDupes.get((Object)"key"), (Collection)ImmutableList.of((Object)"value", (Object)"value"));
        Multimap resources = (Multimap)this.multimap.fromJson("{\"i-foo\":[{\"id\":\"i-foo\",\"name\":\"foo\"}],\"i-bar\":[{\"id\":\"i-bar\",\"name\":\"bar\"}]}", this.multimapResourceType);
        Assert.assertEquals((Object)resources, (Object)ImmutableMultimap.of((Object)"i-foo", (Object)new Resource("i-foo", "foo"), (Object)"i-bar", (Object)new Resource("i-bar", "bar")));
        Multimap resourceDupes = (Multimap)this.multimap.fromJson("{\"i-foo\":[{\"id\":\"i-foo\",\"name\":\"foo\"},{\"id\":\"i-bar\",\"name\":\"bar\"}]}", this.multimapResourceType);
        Assert.assertEquals((Collection)resourceDupes.get((Object)"i-foo"), (Collection)ImmutableList.of((Object)new Resource("i-foo", "foo"), (Object)new Resource("i-bar", "bar")));
    }

    private static class Resource {
        private final String id;
        private final String name;

        private Resource(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.name});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Resource that = (Resource)Resource.class.cast(obj);
            return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name);
        }
    }
}

