/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.internal.NullHackJsonLiteralAdapter;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="NullHackJsonLiteralAdapterTest")
public class NullHackJsonLiteralAdapterTest {
    private Gson gsonAdapter = new GsonBuilder().registerTypeAdapter(RawJson.class, (Object)new RawJsonAdapter()).create();
    Type type = new TypeToken<Map<String, RawJson>>(){}.getType();

    public void testObject() {
        String json = "{\"tomcat6\":{\"ssl_port\":8433}}";
        ImmutableMap map = ImmutableMap.of((Object)"tomcat6", (Object)new RawJson("{\"ssl_port\":8433}"));
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)map), (String)json);
        Assert.assertEquals((Object)this.gsonAdapter.fromJson(json, this.type), (Object)map);
    }

    public void testList() {
        String json = "{\"list\":[8431,8433]}";
        ImmutableMap map = ImmutableMap.of((Object)"list", (Object)new RawJson("[8431,8433]"));
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)map), (String)json);
        Assert.assertEquals((Object)this.gsonAdapter.fromJson(json, this.type), (Object)map);
    }

    public void testString() {
        String json = "{\"name\":\"fooy\"}";
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)new RawJson("fooy"));
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)map), (String)json);
        Assert.assertEquals((Object)this.gsonAdapter.fromJson(json, this.type), (Object)map);
    }

    public void testNumber() {
        String json = "{\"number\":1.0}";
        ImmutableMap map = ImmutableMap.of((Object)"number", (Object)new RawJson(1.0));
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)map), (String)json);
        Assert.assertEquals((Object)this.gsonAdapter.fromJson(json, this.type), (Object)map);
    }

    public void testBoolean() {
        String json = "{\"boolean\":false}";
        ImmutableMap map = ImmutableMap.of((Object)"boolean", (Object)new RawJson(false));
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)map), (String)json);
        Assert.assertEquals((Object)this.gsonAdapter.fromJson(json, this.type), (Object)map);
    }

    public static class RawJsonAdapter
    extends NullHackJsonLiteralAdapter<RawJson> {
        protected RawJson createJsonLiteralFromRawJson(String json) {
            return new RawJson(json);
        }
    }

    static class RawJson
    implements CharSequence {
        private final String value;

        public RawJson(double value) {
            this.value = value + "";
        }

        public RawJson(boolean value) {
            this.value = value + "";
        }

        public RawJson(String value) {
            this.value = RawJson.quoteStringIfNotNumberOrBoolean((String)Preconditions.checkNotNull((Object)value, (Object)"value"));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            return Objects.equal((Object)this.toString(), (Object)that.toString());
        }

        @Override
        public String toString() {
            return this.value;
        }

        static String quoteStringIfNotNumberOrBoolean(String in) {
            if (JsonBall.JSON_STRING_PATTERN.matcher(in).find() && !JsonBall.JSON_NUMBER_PATTERN.matcher(in).find() && !JsonBall.JSON_BOOLEAN_PATTERN.matcher(in).find()) {
                return "\"" + in + "\"";
            }
            return in;
        }

        @Override
        public char charAt(int index) {
            return this.value.charAt(index);
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.value.subSequence(start, end);
        }
    }
}

