/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.location.suppliers.all.RegionToProvider;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionToProviderTest")
public class RegionToProviderTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("servo").description("http://servo").iso3166Codes((Iterable)ImmutableSet.of((Object)"US")).build();
    JustProvider justProvider = new JustProvider("servo", Suppliers.ofInstance((Object)URI.create("http://servo")), (Set)ImmutableSet.of((Object)"US"));

    @Test
    public void test() {
        Supplier regionIdsSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)"region1", (Object)"region2"));
        Supplier locationToIsoCodes = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"servo", (Object)Suppliers.ofInstance((Object)ImmutableSet.of((Object)"US")), (Object)"region1", (Object)Suppliers.ofInstance((Object)ImmutableSet.of((Object)"US-CA")), (Object)"region2", (Object)Suppliers.ofInstance((Object)ImmutableSet.of((Object)"US-VA"))));
        RegionToProvider fn = new RegionToProvider(this.justProvider, regionIdsSupplier, locationToIsoCodes);
        Assert.assertEquals((Set)fn.get(), (Set)ImmutableSet.of((Object)new LocationBuilder().scope(LocationScope.REGION).id("region1").description("region1").iso3166Codes((Iterable)ImmutableSet.of((Object)"US-CA")).parent(this.provider).build(), (Object)new LocationBuilder().scope(LocationScope.REGION).id("region2").description("region2").iso3166Codes((Iterable)ImmutableSet.of((Object)"US-VA")).parent(this.provider).build()));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWhenNoRegions() {
        Supplier regionIdsSupplier = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier locationToIsoCodes = Suppliers.ofInstance((Object)ImmutableMap.of());
        RegionToProvider fn = new RegionToProvider(this.justProvider, regionIdsSupplier, locationToIsoCodes);
        fn.get();
    }
}

