/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.proxy;

import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import org.jclouds.domain.Credentials;
import org.jclouds.proxy.ProxyConfig;
import org.jclouds.proxy.ProxyForURI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProxyForURITest {
    private Optional<HostAndPort> noHostAndPort = Optional.absent();
    private Optional<Credentials> noCreds = Optional.absent();
    private Optional<HostAndPort> hostAndPort = Optional.of((Object)HostAndPort.fromParts((String)"proxy.example.com", (int)8080));
    private Optional<Credentials> creds = Optional.of((Object)new Credentials("user", "pwd"));

    @Test
    public void testDontUseProxyForSockets() throws Exception {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.HTTP, this.hostAndPort, this.creds);
        ProxyForURI proxy = new ProxyForURI((ProxyConfig)config);
        Field useProxyForSockets = proxy.getClass().getDeclaredField("useProxyForSockets");
        useProxyForSockets.setAccessible(true);
        useProxyForSockets.setBoolean(proxy, false);
        URI uri = new URI("socket://ssh.example.com:22");
        Assert.assertEquals((Object)proxy.apply(uri), (Object)Proxy.NO_PROXY);
    }

    @Test
    public void testUseProxyForSockets() throws Exception {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.HTTP, this.hostAndPort, this.creds);
        ProxyForURI proxy = new ProxyForURI((ProxyConfig)config);
        URI uri = new URI("socket://ssh.example.com:22");
        Assert.assertEquals((Object)proxy.apply(uri), (Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy.example.com", 8080)));
    }

    @Test
    public void testUseProxyForSocketsSettingShouldntAffectHTTP() throws Exception {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.HTTP, this.hostAndPort, this.creds);
        ProxyForURI proxy = new ProxyForURI((ProxyConfig)config);
        Field useProxyForSockets = proxy.getClass().getDeclaredField("useProxyForSockets");
        useProxyForSockets.setAccessible(true);
        useProxyForSockets.setBoolean(proxy, false);
        URI uri = new URI("http://example.com/file");
        Assert.assertEquals((Object)proxy.apply(uri), (Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy.example.com", 8080)));
    }

    @Test
    public void testHTTPDirect() throws URISyntaxException {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.DIRECT, this.noHostAndPort, this.noCreds);
        URI uri = new URI("http://example.com/file");
        Assert.assertEquals((Object)new ProxyForURI((ProxyConfig)config).apply(uri), (Object)Proxy.NO_PROXY);
    }

    @Test
    public void testHTTPSDirect() throws URISyntaxException {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.DIRECT, this.noHostAndPort, this.noCreds);
        URI uri = new URI("https://example.com/file");
        Assert.assertEquals((Object)new ProxyForURI((ProxyConfig)config).apply(uri), (Object)Proxy.NO_PROXY);
    }

    @Test
    public void testFTPDirect() throws URISyntaxException {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.DIRECT, this.noHostAndPort, this.noCreds);
        URI uri = new URI("ftp://ftp.example.com/file");
        Assert.assertEquals((Object)new ProxyForURI((ProxyConfig)config).apply(uri), (Object)Proxy.NO_PROXY);
    }

    @Test
    public void testSocketDirect() throws URISyntaxException {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.DIRECT, this.noHostAndPort, this.noCreds);
        URI uri = new URI("socket://ssh.example.com:22");
        Assert.assertEquals((Object)new ProxyForURI((ProxyConfig)config).apply(uri), (Object)Proxy.NO_PROXY);
    }

    @Test
    public void testHTTPThroughHTTPProxy() throws URISyntaxException {
        MyProxyConfig config = new MyProxyConfig(false, Proxy.Type.HTTP, this.hostAndPort, this.creds);
        URI uri = new URI("http://example.com/file");
        Assert.assertEquals((Object)new ProxyForURI((ProxyConfig)config).apply(uri), (Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy.example.com", 8080)));
    }

    @Test
    public void testHTTPThroughSystemProxy() throws URISyntaxException {
        MyProxyConfig config = new MyProxyConfig(true, Proxy.Type.DIRECT, this.noHostAndPort, this.noCreds);
        URI uri = new URI("http://example.com/file");
        Assert.assertNotNull((Object)new ProxyForURI((ProxyConfig)config).apply(uri));
    }

    private class MyProxyConfig
    implements ProxyConfig {
        private boolean useSystem;
        private Proxy.Type type;
        private Optional<HostAndPort> proxy;
        private Optional<Credentials> credentials;

        MyProxyConfig(boolean useSystem, Proxy.Type type, Optional<HostAndPort> proxy, Optional<Credentials> credentials) {
            this.useSystem = useSystem;
            this.type = type;
            this.proxy = proxy;
            this.credentials = credentials;
        }

        public boolean useSystem() {
            return this.useSystem;
        }

        public Proxy.Type getType() {
            return this.type;
        }

        public Optional<HostAndPort> getProxy() {
            return this.proxy;
        }

        public Optional<Credentials> getCredentials() {
            return this.credentials;
        }
    }
}

