/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.annotationparsing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ProvidesAnnotationExpectTest")
public class ProvidesAnnotationExpectTest
extends BaseRestClientExpectTest<ProvidingApi> {
    @Test
    public void testProvidesWithGeneric() {
        ProvidingApi client = (ProvidingApi)this.requestsSendResponses((Map<HttpRequest, HttpResponse>)ImmutableMap.of());
        Assert.assertEquals(client.set(), (Set)ImmutableSet.of((Object)"foo"));
    }

    @Test
    public void testProvidesWithGenericQualified() {
        ProvidingApi client = (ProvidingApi)this.requestsSendResponses((Map<HttpRequest, HttpResponse>)ImmutableMap.of());
        Assert.assertEquals(client.foo(), (Set)ImmutableSet.of((Object)"bar"));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testProvidesWithGenericQualifiedAuthorizationException() {
        ProvidingApi client = (ProvidingApi)this.requestsSendResponses((Map<HttpRequest, HttpResponse>)ImmutableMap.of());
        client.exception();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testProvidesWithGenericQualifiedNoSuchElementException() {
        ProvidingApi client = (ProvidingApi)this.requestsSendResponses((Map<HttpRequest, HttpResponse>)ImmutableMap.of());
        client.noSuchElementException();
    }

    @Override
    public ProviderMetadata createProviderMetadata() {
        return AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(ProvidingApi.class, ProvidingAsyncApi.class, (String)"http://mock");
    }

    @Override
    protected Module createModule() {
        return new ProvidingRestClientModule();
    }

    @ConfiguresRestClient
    static class ProvidingRestClientModule
    extends RestClientModule<ProvidingApi, ProvidingAsyncApi> {
        ProvidingRestClientModule() {
        }

        protected void configure() {
            super.configure();
            this.bind((TypeLiteral)new TypeLiteral<Set<String>>(){}).toInstance((Object)ImmutableSet.of((Object)"foo"));
            this.bind((TypeLiteral)new TypeLiteral<Set<String>>(){}).annotatedWith((Annotation)Names.named((String)"bar")).toInstance((Object)ImmutableSet.of((Object)"bar"));
        }

        @Provides
        @Named(value="exception")
        Set<String> exception() {
            throw new AuthorizationException();
        }

        @Provides
        @Named(value="NoSuchElementException")
        Set<String> noSuchElementException() {
            throw new NoSuchElementException();
        }
    }

    static interface ProvidingAsyncApi
    extends Closeable {
        @Provides
        public Set<String> set();

        @Named(value="bar")
        @Provides
        public Set<String> foo();

        @Named(value="exception")
        @Provides
        public Set<String> exception();

        @Named(value="NoSuchElementException")
        @Provides
        public Set<String> noSuchElementException();
    }

    static interface ProvidingApi
    extends Closeable {
        @Provides
        public Set<String> set();

        @Named(value="bar")
        @Provides
        public Set<String> foo();

        @Named(value="exception")
        @Provides
        public Set<String> exception();

        @Named(value="NoSuchElementException")
        @Provides
        public Set<String> noSuchElementException();
    }
}

