/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;
import org.jclouds.json.internal.NamingStrategies;
import org.jclouds.reflect.Reflection2;

public final class DeserializationConstructorAndReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final NamingStrategies.AnnotationConstructorNamingStrategy constructorFieldNamingPolicy;
    private final ReflectiveTypeAdapterFactory delegateFactory;

    public DeserializationConstructorAndReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy serializationFieldNamingPolicy, Excluder excluder, NamingStrategies.AnnotationConstructorNamingStrategy deserializationFieldNamingPolicy) {
        this.constructorFieldNamingPolicy = (NamingStrategies.AnnotationConstructorNamingStrategy)Preconditions.checkNotNull((Object)deserializationFieldNamingPolicy, (Object)"deserializationFieldNamingPolicy");
        this.delegateFactory = new ReflectiveTypeAdapterFactory(constructorConstructor, (FieldNamingStrategy)Preconditions.checkNotNull((Object)serializationFieldNamingPolicy, (Object)"fieldNamingPolicy"), (Excluder)Preconditions.checkNotNull((Object)excluder, (Object)"excluder"));
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        com.google.common.reflect.TypeToken token = Reflection2.typeToken(type.getType());
        Invokable deserializationCtor = this.constructorFieldNamingPolicy.getDeserializer(token);
        if (deserializationCtor == null) {
            return null;
        }
        return new DeserializeIntoParameterizedConstructor(this.delegateFactory.create(gson, type), deserializationCtor, this.getParameterReaders(gson, deserializationCtor));
    }

    private <T> Map<String, ParameterReader<?>> getParameterReaders(Gson context, Invokable<T, T> deserializationCtor) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Parameter param : deserializationCtor.getParameters()) {
            TypeAdapter adapter = context.getAdapter(TypeToken.get((Type)param.getType().getType()));
            String parameterName = this.constructorFieldNamingPolicy.translateName(deserializationCtor, param.hashCode());
            Preconditions.checkArgument((parameterName != null ? 1 : 0) != 0, (Object)(deserializationCtor + " parameter " + 0 + " failed to be named by " + this.constructorFieldNamingPolicy));
            ParameterReader parameterReader = new ParameterReader(param.hashCode(), parameterName, adapter);
            result.put((Object)parameterReader.name, parameterReader);
        }
        return result.build();
    }

    static class ParameterReader<T> {
        final String name;
        final int position;
        final TypeAdapter<T> typeAdapter;

        ParameterReader(int position, String name, TypeAdapter<T> typeAdapter) {
            this.name = name;
            this.position = position;
            this.typeAdapter = typeAdapter;
        }

        public Object read(JsonReader reader) throws IOException {
            return this.typeAdapter.read(reader);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParameterReader) {
                ParameterReader that = (ParameterReader)ParameterReader.class.cast(obj);
                return this.position == that.position && this.name.equals(that.name);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.position, this.name});
        }

        public String toString() {
            return this.typeAdapter + " arg" + this.position;
        }
    }

    private final class DeserializeIntoParameterizedConstructor<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> serializer;
        private final Invokable<T, T> parameterizedCtor;
        private final Map<String, ParameterReader<?>> parameterReaders;

        private DeserializeIntoParameterizedConstructor(TypeAdapter<T> serializer, Invokable<T, T> deserializationCtor, Map<String, ParameterReader<?>> parameterReaders) {
            this.serializer = serializer;
            this.parameterizedCtor = deserializationCtor;
            this.parameterReaders = parameterReaders;
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableList params = this.parameterizedCtor.getParameters();
            Object[] values = new Object[params.size()];
            boolean empty = true;
            for (Parameter param : params) {
                if (param.getType().getRawType() == Boolean.TYPE) {
                    values[param.hashCode()] = Boolean.FALSE;
                    continue;
                }
                if (!param.getType().getRawType().isPrimitive()) continue;
                values[param.hashCode()] = 0;
            }
            try {
                in.beginObject();
                while (in.hasNext()) {
                    empty = false;
                    String name = in.nextName();
                    ParameterReader<?> parameter = this.parameterReaders.get(name);
                    if (parameter == null) {
                        in.skipValue();
                        continue;
                    }
                    Object value = parameter.read(in);
                    if (value == null) continue;
                    values[parameter.position] = value;
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
            for (Parameter param : params) {
                if (param.getType().getRawType().isPrimitive()) {
                    Preconditions.checkArgument((values[param.hashCode()] != null ? 1 : 0) != 0, (String)"Primitive param[%s] in constructor %s cannot be absent!", (Object[])new Object[]{param.hashCode(), this.parameterizedCtor});
                    continue;
                }
                if (param.getType().getRawType() != Optional.class || values[param.hashCode()] != null) continue;
                values[param.hashCode()] = Optional.absent();
            }
            in.endObject();
            try {
                return this.newInstance(values);
            }
            catch (NullPointerException ex) {
                if (empty && values.length > 0) {
                    return null;
                }
                throw ex;
            }
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.serializer.write(out, value);
        }

        private T newInstance(Object[] ctorParams) throws AssertionError {
            try {
                return (T)this.parameterizedCtor.invoke(null, ctorParams);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)RuntimeException.class.cast(e.getCause());
                }
                throw new AssertionError((Object)e);
            }
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.serializer, this.parameterizedCtor, this.parameterReaders});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            DeserializeIntoParameterizedConstructor that = (DeserializeIntoParameterizedConstructor)((Object)DeserializeIntoParameterizedConstructor.class.cast(obj));
            return Objects.equal(this.serializer, that.serializer) && Objects.equal(this.parameterizedCtor, that.parameterizedCtor) && Objects.equal(this.parameterReaders, that.parameterReaders);
        }

        public String toString() {
            return Objects.toStringHelper((Object)((Object)this)).add("parameterizedCtor", this.parameterizedCtor).add("parameterReaders", this.parameterReaders).add("serializer", this.serializer).toString();
        }
    }
}

