/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;

public class BindIterableAsPayloadToDeleteRequest
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input is null") instanceof Iterable), (Object)"this binder is only valid for an Iterable");
        Preconditions.checkNotNull(request, (Object)"request is null");
        Iterable keys = (Iterable)input;
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(String.format("<Object><Key>%s</Key></Object>", key));
        }
        String objects = builder.toString();
        Preconditions.checkArgument((!objects.isEmpty() ? 1 : 0) != 0, (Object)"The list of keys should not be empty.");
        String content = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete>%s</Delete>", objects);
        StringPayload payload = Payloads.newStringPayload((String)content);
        payload.getContentMetadata().setContentType("text/xml");
        byte[] md5 = Hashing.md5().hashString((CharSequence)content, Charsets.UTF_8).asBytes();
        payload.getContentMetadata().setContentMD5(md5);
        request.setPayload((Payload)payload);
        return request;
    }
}

