/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.services;

import com.google.common.base.Throwables;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.services.BucketsLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="AWSBucketsLiveTest")
public class AWSBucketsLiveTest
extends BucketsLiveTest {
    public AWSBucketsLiveTest() {
        this.provider = "aws-s3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultBucketLocation() throws Exception {
        String bucketName = this.getContainerName();
        try {
            String location = this.getApi().getBucketLocation(bucketName);
            assert (location.equals("us-standard")) : "bucket: " + bucketName + " location: " + location;
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEu() throws Exception {
        final String bucketName = this.getScratchContainerName();
        try {
            this.getApi().putBucketInRegion("eu-west-1", bucketName + "eu", new PutBucketOptions[]{PutBucketOptions.Builder.withBucketAcl((CannedAccessPolicy)CannedAccessPolicy.PUBLIC_READ)});
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessControlList acl = AWSBucketsLiveTest.this.getApi().getBucketACL(bucketName + "eu");
                        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"), (String)acl.toString());
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
            Assert.assertEquals((String)"eu-west-1", (String)this.getApi().getBucketLocation(bucketName + "eu"));
        }
        finally {
            this.destroyContainer(bucketName + "eu");
        }
    }
}

