/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.options;

import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.options.PutObjectOptions;

public class AWSS3PutObjectOptions
extends PutObjectOptions {
    public static final ObjectMetadata.StorageClass DEFAULT_STORAGE_CLASS = ObjectMetadata.StorageClass.STANDARD;
    private final ObjectMetadata.StorageClass storageClass;

    protected AWSS3PutObjectOptions(PutObjectOptions s3Options, ObjectMetadata.StorageClass storageClass) {
        super(s3Options.getAcl(), s3Options.usesServerSideEncryption());
        this.storageClass = storageClass;
    }

    public ObjectMetadata.StorageClass getStorageClass() {
        return this.storageClass;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends PutObjectOptions.Builder {
        private ObjectMetadata.StorageClass storageClass = DEFAULT_STORAGE_CLASS;

        protected Builder() {
        }

        public Builder storageClass(ObjectMetadata.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public AWSS3PutObjectOptions build() {
            AWSS3PutObjectOptions rv = new AWSS3PutObjectOptions(super.build(), this.storageClass);
            if (this.storageClass != ObjectMetadata.StorageClass.STANDARD) {
                rv.replaceHeader("x-amz-storage-class", this.storageClass.toString());
            }
            return rv;
        }
    }
}

