/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.BrissTransferHandler;
import at.laborg.briss.exception.CropException;
import at.laborg.briss.gui.HelpDialog;
import at.laborg.briss.gui.MergedPanel;
import at.laborg.briss.gui.WrapLayout;
import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.CropDefinition;
import at.laborg.briss.model.PageCluster;
import at.laborg.briss.model.PageExcludes;
import at.laborg.briss.model.WorkingSet;
import at.laborg.briss.utils.BrissFileHandling;
import at.laborg.briss.utils.ClusterCreator;
import at.laborg.briss.utils.ClusterRenderWorker;
import at.laborg.briss.utils.DesktopHelper;
import at.laborg.briss.utils.DocumentCropper;
import at.laborg.briss.utils.PDFFileFilter;
import at.laborg.briss.utils.PageNumberParser;
import com.itextpdf.text.DocumentException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jpedal.exception.PdfException;

public class BrissGUI
extends JFrame
implements ActionListener,
PropertyChangeListener,
ComponentListener {
    private static final String EXCLUDE_PAGES_DESCRIPTION = "Enter pages to be excluded from merging (e.g.: \"1-4;6;9\").\nFirst page has number: 1\nIf you don't know what you should do just press \"Cancel\"";
    private static final String LOAD = "Load File";
    private static final String CROP = "Crop PDF";
    private static final String EXIT = "Exit";
    private static final String MAXIMIZE_WIDTH = "Maximize to width";
    private static final String MAXIMIZE_HEIGHT = "Maximize to height";
    private static final String EXCLUDE_OTHER_PAGES = "Exclude other pages";
    private static final String PREVIEW = "Preview";
    private static final String DONATE = "Donate";
    private static final String HELP = "Show help";
    private static final String DONATION_URI = "http://sourceforge.net/project/project_donations.php?group_id=320676";
    private static final String RES_ICON_PATH = "/Briss_icon_032x032.gif";
    private JMenuBar menuBar;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JMenuItem loadButton;
    private JMenuItem cropButton;
    private JMenuItem maximizeWidthButton;
    private JMenuItem maximizeHeightButton;
    private JMenuItem showPreviewButton;
    private JMenuItem showHelpButton;
    private JMenuItem openDonationLinkButton;
    private JMenuItem excludePagesButton;
    private List<MergedPanel> mergedPanels = null;
    private File lastOpenDir;
    private WorkingSet workingSet;

    public BrissGUI(String[] args) {
        super("BRISS - BRight Snippet Sire");
        this.init();
        this.tryToLoadFileFromArgument(args);
    }

    private void tryToLoadFileFromArgument(String[] args) {
        if (args.length == 0) {
            return;
        }
        File fileArg = new File(args[0]);
        if (fileArg.exists() && fileArg.getAbsolutePath().trim().endsWith(".pdf")) {
            try {
                this.importNewPdfFile(fileArg);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Briss error", 0);
            }
            catch (PdfException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Briss error", 0);
            }
        }
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        this.setTransferHandler(new BrissTransferHandler(this));
        this.setUILook();
        this.loadIcon();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenu actionMenu = new JMenu("Action");
        actionMenu.setMnemonic(65);
        this.menuBar.add(fileMenu);
        this.menuBar.add(actionMenu);
        this.loadButton = new JMenuItem(LOAD, 76);
        this.loadButton.addActionListener(this);
        this.loadButton.setEnabled(true);
        fileMenu.add(this.loadButton);
        fileMenu.addSeparator();
        this.openDonationLinkButton = new JMenuItem(DONATE);
        this.openDonationLinkButton.addActionListener(this);
        fileMenu.add(this.openDonationLinkButton);
        this.excludePagesButton = new JMenuItem(EXCLUDE_OTHER_PAGES);
        this.excludePagesButton.addActionListener(this);
        this.excludePagesButton.setEnabled(false);
        fileMenu.add(this.excludePagesButton);
        this.showHelpButton = new JMenuItem(HELP);
        this.showHelpButton.addActionListener(this);
        fileMenu.add(this.showHelpButton);
        fileMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem(EXIT, 69);
        menuItem.addActionListener(this);
        fileMenu.add(menuItem);
        this.cropButton = new JMenuItem(CROP, 67);
        this.cropButton.addActionListener(this);
        this.cropButton.setEnabled(false);
        actionMenu.add(this.cropButton);
        this.showPreviewButton = new JMenuItem(PREVIEW, 80);
        this.showPreviewButton.addActionListener(this);
        this.showPreviewButton.setEnabled(false);
        actionMenu.add(this.showPreviewButton);
        this.maximizeWidthButton = new JMenuItem(MAXIMIZE_WIDTH, 87);
        this.maximizeWidthButton.addActionListener(this);
        this.maximizeWidthButton.setEnabled(false);
        actionMenu.add(this.maximizeWidthButton);
        this.maximizeHeightButton = new JMenuItem(MAXIMIZE_HEIGHT, 72);
        this.maximizeHeightButton.addActionListener(this);
        this.maximizeHeightButton.setEnabled(false);
        actionMenu.add(this.maximizeHeightButton);
        this.setJMenuBar(this.menuBar);
        this.previewPanel = new JPanel();
        this.previewPanel.setLayout(new WrapLayout(0, 4, 4));
        this.previewPanel.setEnabled(true);
        this.previewPanel.setBackground(Color.BLACK);
        this.previewPanel.addComponentListener(this);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(400, 30));
        this.progressBar.setEnabled(true);
        JScrollPane scrollPane = new JScrollPane(this.previewPanel, 22, 30);
        scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.progressBar, "Last");
        this.pack();
        this.setVisible(true);
    }

    private void setUILook() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ex) {
            System.out.println("Unable to load native look and feel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void loadIcon() {
        InputStream is = this.getClass().getResourceAsStream(RES_ICON_PATH);
        byte[] buf = new byte[102400];
        try {
            int cnt = is.read(buf);
            byte[] imgBuf = Arrays.copyOf(buf, cnt);
            this.setIconImage(new ImageIcon(imgBuf).getImage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static PageExcludes getExcludedPages() {
        boolean inputIsValid = false;
        String previousInput = "";
        while (!inputIsValid) {
            String input;
            previousInput = input = JOptionPane.showInputDialog(EXCLUDE_PAGES_DESCRIPTION, (Object)previousInput);
            if (input == null || input.equals("")) {
                return null;
            }
            try {
                PageExcludes pageExcludes = new PageExcludes(PageNumberParser.parsePageNumber(input));
                return pageExcludes;
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Input Error", 0);
            }
        }
        return null;
    }

    private File getCropFileDestination(File sourceFile) {
        File recommendedFile = BrissFileHandling.getRecommendedDestination(sourceFile);
        JFileChooser fc = new JFileChooser(this.lastOpenDir);
        fc.setSelectedFile(recommendedFile);
        fc.setFileFilter(new PDFFileFilter());
        int retval = fc.showSaveDialog(this);
        if (retval == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    private File getNewFileToCrop() {
        JFileChooser fc = new JFileChooser(this.lastOpenDir);
        fc.setFileFilter(new PDFFileFilter());
        int retval = fc.showOpenDialog(this);
        if (retval == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals(DONATE)) {
            try {
                DesktopHelper.openDonationLink(DONATION_URI);
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while loading", 0);
            }
            return;
        }
        if (action.getActionCommand().equals(EXIT)) {
            System.exit(0);
            return;
        }
        if (action.getActionCommand().equals(HELP)) {
            new HelpDialog((Frame)this, "Briss Help", Dialog.ModalityType.MODELESS);
            return;
        }
        if (action.getActionCommand().equals(MAXIMIZE_HEIGHT)) {
            this.maximizeHeightInSelectedRects();
            return;
        }
        if (action.getActionCommand().equals(MAXIMIZE_WIDTH)) {
            this.maximizeWidthInSelectedRects();
            return;
        }
        if (action.getActionCommand().equals(EXCLUDE_OTHER_PAGES)) {
            if (this.workingSet.getSourceFile() == null) {
                return;
            }
            this.setWorkingState(EXCLUDE_OTHER_PAGES);
            try {
                this.reloadWithOtherExcludes();
                this.setTitle("BRISS - " + this.workingSet.getSourceFile().getName());
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while reloading", 0);
                return;
            }
            catch (PdfException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while reloading", 0);
            }
            return;
        }
        if (action.getActionCommand().equals(LOAD)) {
            File inputFile = this.getNewFileToCrop();
            if (inputFile == null) {
                return;
            }
            try {
                this.importNewPdfFile(inputFile);
                this.setTitle("BRISS - " + inputFile.getName());
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while loading", 0);
                return;
            }
            catch (PdfException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while loading", 0);
            }
            return;
        }
        if (action.getActionCommand().equals(CROP)) {
            try {
                try {
                    this.setWorkingState("loading PDF");
                    File result = this.createAndExecuteCropJob(this.workingSet.getSourceFile());
                    if (result == null) return;
                    DesktopHelper.openFileWithDesktopApp(result);
                    this.lastOpenDir = result.getParentFile();
                    return;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while cropping", 0);
                    this.setIdleState("");
                    return;
                }
                catch (DocumentException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while cropping", 0);
                    this.setIdleState("");
                    return;
                }
                catch (CropException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while cropping", 0);
                    this.setIdleState("");
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.setIdleState("");
            }
        }
        if (!action.getActionCommand().equals(PREVIEW)) return;
        try {
            try {
                this.setWorkingState("Creating and showing preview...");
                File result = this.createAndExecuteCropJobForPreview();
                DesktopHelper.openFileWithDesktopApp(result);
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while cropping", 0);
                this.setIdleState("");
                return;
            }
            catch (DocumentException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while cropping", 0);
                this.setIdleState("");
                return;
            }
            catch (CropException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured while cropping", 0);
                this.setIdleState("");
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.setIdleState("");
        }
    }

    private File createAndExecuteCropJobForPreview() throws IOException, DocumentException, CropException {
        File tmpCropFileDestination = File.createTempFile("briss", ".pdf");
        CropDefinition cropDefinition = CropDefinition.createCropDefinition(this.workingSet.getSourceFile(), tmpCropFileDestination, this.workingSet.getClusterDefinition());
        File result = DocumentCropper.crop(cropDefinition);
        return result;
    }

    private File createAndExecuteCropJob(File source) throws IOException, DocumentException, CropException {
        File cropDestinationFile = this.getCropFileDestination(this.workingSet.getSourceFile());
        if (cropDestinationFile == null) {
            return null;
        }
        CropDefinition cropDefinition = CropDefinition.createCropDefinition(this.workingSet.getSourceFile(), cropDestinationFile, this.workingSet.getClusterDefinition());
        File result = DocumentCropper.crop(cropDefinition);
        return result;
    }

    private void setIdleState(String stateMessage) {
        this.progressBar.setValue(0);
        this.progressBar.setString(stateMessage);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setWorkingState(String stateMessage) {
        this.progressBar.setString(stateMessage);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    void importNewPdfFile(File loadFile) throws IOException, PdfException {
        this.lastOpenDir = loadFile.getParentFile();
        this.previewPanel.removeAll();
        this.progressBar.setString("Loading new file - Creating merged previews");
        ClusterPagesTask clusterTask = new ClusterPagesTask(loadFile, BrissGUI.getExcludedPages());
        clusterTask.addPropertyChangeListener(this);
        clusterTask.execute();
    }

    private void reloadWithOtherExcludes() throws IOException, PdfException {
        this.previewPanel.removeAll();
        this.progressBar.setString("Reloading file - Creating merged previews");
        ClusterPagesTask clusterTask = new ClusterPagesTask(this.workingSet.getSourceFile(), BrissGUI.getExcludedPages());
        clusterTask.addPropertyChangeListener(this);
        clusterTask.execute();
    }

    private void maximizeWidthInSelectedRects() {
        int maxWidth = -1;
        for (MergedPanel panel : this.mergedPanels) {
            int panelMaxWidth = panel.getWidestSelectedRect();
            if (maxWidth >= panelMaxWidth) continue;
            maxWidth = panelMaxWidth;
        }
        if (maxWidth == -1) {
            return;
        }
        for (MergedPanel mp : this.mergedPanels) {
            mp.setSelCropWidth(maxWidth);
        }
    }

    private void maximizeHeightInSelectedRects() {
        int maxHeight = -1;
        for (MergedPanel panel : this.mergedPanels) {
            int panelMaxHeight = panel.getHeighestSelectedRect();
            if (maxHeight >= panelMaxHeight) continue;
            maxHeight = panelMaxHeight;
        }
        if (maxHeight == -1) {
            return;
        }
        for (MergedPanel mp : this.mergedPanels) {
            mp.setSelCropHeight(maxHeight);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            this.progressBar.setValue((Integer)evt.getNewValue());
        }
    }

    private void setStateAfterClusteringFinished(ClusterDefinition newClusters, PageExcludes newPageExcludes, File newSource) {
        this.updateWorkingSet(newClusters, newPageExcludes, newSource);
        this.previewPanel.removeAll();
        this.mergedPanels = new ArrayList<MergedPanel>();
        for (PageCluster cluster : this.workingSet.getClusterDefinition().getClusterList()) {
            MergedPanel p = new MergedPanel(cluster);
            this.previewPanel.add(p);
            this.mergedPanels.add(p);
        }
        this.progressBar.setString("Clustering and Rendering finished");
        this.cropButton.setEnabled(true);
        this.maximizeWidthButton.setEnabled(true);
        this.maximizeHeightButton.setEnabled(true);
        this.excludePagesButton.setEnabled(true);
        this.showPreviewButton.setEnabled(true);
        this.setIdleState("");
        this.pack();
        this.setExtendedState(6);
        this.previewPanel.repaint();
        this.repaint();
    }

    private void updateWorkingSet(ClusterDefinition newClusters, PageExcludes newPageExcludes, File newSource) {
        if (this.workingSet == null) {
            this.workingSet = new WorkingSet(newSource);
        } else if (this.workingSet.getSourceFile().equals(newSource)) {
            this.copyCropsToClusters(this.workingSet.getClusterDefinition(), newClusters);
        }
        this.workingSet.setSourceFile(newSource);
        this.workingSet.setClusters(newClusters);
        this.workingSet.setPageExcludes(newPageExcludes);
    }

    private void copyCropsToClusters(ClusterDefinition oldClusters, ClusterDefinition newClusters) {
        for (PageCluster newCluster : newClusters.getClusterList()) {
            for (Integer pageNumber : newCluster.getAllPages()) {
                PageCluster oldCluster = oldClusters.getSingleCluster(pageNumber);
                for (Float[] ratios : oldCluster.getRatiosList()) {
                    newCluster.addRatios(ratios);
                }
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.previewPanel.revalidate();
        Component[] componentArray = this.previewPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.repaint();
            ++n2;
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private class ClusterPagesTask
    extends SwingWorker<Void, Void> {
        private final File source;
        private final PageExcludes pageExcludes;
        private ClusterDefinition clusterDefinition = null;

        public ClusterPagesTask(File source, PageExcludes pageExcludes) {
            this.source = source;
            this.pageExcludes = pageExcludes;
        }

        @Override
        protected void done() {
            BrissGUI.this.setStateAfterClusteringFinished(this.clusterDefinition, this.pageExcludes, this.source);
        }

        @Override
        protected Void doInBackground() {
            try {
                this.clusterDefinition = ClusterCreator.clusterPages(this.source, this.pageExcludes);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
            int totalWorkUnits = this.clusterDefinition.getNrOfPagesToRender();
            ClusterRenderWorker renderWorker = new ClusterRenderWorker(this.source, this.clusterDefinition);
            renderWorker.start();
            while (renderWorker.isAlive()) {
                int percent = (int)((float)renderWorker.workerUnitCounter / (float)totalWorkUnits * 100.0f);
                this.setProgress(percent);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

