/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import at.laborg.briss.exception.CropException;
import at.laborg.briss.model.CropDefinition;
import at.laborg.briss.utils.BrissFileHandling;
import at.laborg.briss.utils.RectangleHandler;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DocumentCropper {
    public static File crop(CropDefinition cropDefinition) throws IOException, DocumentException, CropException {
        if (!BrissFileHandling.checkValidStateAndCreate(cropDefinition.getDestinationFile())) {
            throw new IOException("Destination file not valid");
        }
        if (DocumentCropper.isPasswordRequired(cropDefinition.getSourceFile())) {
            throw new CropException("Password required");
        }
        PdfMetaInformation pdfMetaInformation = new PdfMetaInformation(cropDefinition.getSourceFile());
        File intermediatePdf = DocumentCropper.copyToMultiplePages(cropDefinition, pdfMetaInformation);
        DocumentCropper.cropMultipliedFile(cropDefinition, intermediatePdf, pdfMetaInformation);
        return cropDefinition.getDestinationFile();
    }

    private static File copyToMultiplePages(CropDefinition cropDefinition, PdfMetaInformation pdfMetaInformation) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(cropDefinition.getSourceFile().getAbsolutePath());
        Document document = new Document();
        File resultFile = File.createTempFile("cropped", ".pdf");
        PdfSmartCopy pdfCopy = new PdfSmartCopy(document, (OutputStream)new FileOutputStream(resultFile));
        document.open();
        int pageNumber = 1;
        while (pageNumber <= pdfMetaInformation.getSourcePageCount()) {
            PdfImportedPage pdfPage = pdfCopy.getImportedPage(reader, pageNumber);
            pdfCopy.addPage(pdfPage);
            List<Float[]> rectangles = cropDefinition.getRectanglesForPage(pageNumber);
            int j = 1;
            while (j < rectangles.size()) {
                pdfCopy.addPage(pdfPage);
                ++j;
            }
            ++pageNumber;
        }
        document.close();
        pdfCopy.close();
        reader.close();
        return resultFile;
    }

    private static void cropMultipliedFile(CropDefinition cropDefinition, File multipliedDocument, PdfMetaInformation pdfMetaInformation) throws FileNotFoundException, DocumentException, IOException {
        PdfReader reader = new PdfReader(multipliedDocument.getAbsolutePath());
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(cropDefinition.getDestinationFile()));
        stamper.setMoreInfo(pdfMetaInformation.getSourceMetaInfo());
        int newPageNumber = 1;
        int sourcePageNumber = 1;
        while (sourcePageNumber <= pdfMetaInformation.getSourcePageCount()) {
            List<Float[]> rectangleList = cropDefinition.getRectanglesForPage(sourcePageNumber);
            if (rectangleList.isEmpty()) {
                ++newPageNumber;
            } else {
                for (Float[] ratios : rectangleList) {
                    PdfDictionary pageDict = reader.getPageN(newPageNumber);
                    ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
                    boxes.add(reader.getBoxSize(newPageNumber, "media"));
                    boxes.add(reader.getBoxSize(newPageNumber, "crop"));
                    int rotation = reader.getPageRotation(newPageNumber);
                    Rectangle scaledBox = RectangleHandler.calculateScaledRectangle(boxes, ratios, rotation);
                    PdfArray scaleBoxArray = DocumentCropper.createScaledBoxArray(scaledBox);
                    pageDict.put(PdfName.CROPBOX, (PdfObject)scaleBoxArray);
                    pageDict.put(PdfName.MEDIABOX, (PdfObject)scaleBoxArray);
                    ++newPageNumber;
                }
                int[] range = new int[]{newPageNumber - 1, pdfMetaInformation.getSourcePageCount() + (newPageNumber - sourcePageNumber)};
                SimpleBookmark.shiftPageNumbers(pdfMetaInformation.getSourceBookmarks(), (int)(rectangleList.size() - 1), (int[])range);
            }
            ++sourcePageNumber;
        }
        stamper.setOutlines(pdfMetaInformation.getSourceBookmarks());
        stamper.close();
        reader.close();
    }

    private static PdfArray createScaledBoxArray(Rectangle scaledBox) {
        PdfArray scaleBoxArray = new PdfArray();
        scaleBoxArray.add((PdfObject)new PdfNumber(scaledBox.getLeft()));
        scaleBoxArray.add((PdfObject)new PdfNumber(scaledBox.getBottom()));
        scaleBoxArray.add((PdfObject)new PdfNumber(scaledBox.getRight()));
        scaleBoxArray.add((PdfObject)new PdfNumber(scaledBox.getTop()));
        return scaleBoxArray;
    }

    private static boolean isPasswordRequired(File file) throws IOException {
        PdfReader reader = new PdfReader(file.getAbsolutePath());
        boolean isEncrypted = reader.isEncrypted();
        reader.close();
        return isEncrypted;
    }

    private static class PdfMetaInformation {
        private final int sourcePageCount;
        private final HashMap<String, String> sourceMetaInfo;
        private final List<HashMap<String, Object>> sourceBookmarks;

        public PdfMetaInformation(File source) throws IOException {
            PdfReader reader = new PdfReader(source.getAbsolutePath());
            this.sourcePageCount = reader.getNumberOfPages();
            this.sourceMetaInfo = reader.getInfo();
            this.sourceBookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
            reader.close();
        }

        public int getSourcePageCount() {
            return this.sourcePageCount;
        }

        public HashMap<String, String> getSourceMetaInfo() {
            return this.sourceMetaInfo;
        }

        public List<HashMap<String, Object>> getSourceBookmarks() {
            return this.sourceBookmarks;
        }
    }
}

