(ns docker-connect.metrics
  (:require [clojure.string :as string]
            [clojure.tools.logging :as log]
            [clj-datadog.core :as dd]
            [docker-connect.util :as util]))


(defonce statsd {:host "statsd" :port 8125})


(defn set-installs [icount]
  (when (util/in-micros?)
    (dd/gauge statsd (name :bitbucket.addon.docker.install.total) icount)))

(defn inc-installs []
  (when (util/in-micros?)
    (dd/increment statsd (name :bitbucket.addon.docker.install))))

(defn inc-uninstalls []
  (when (util/in-micros?)
    (dd/increment statsd (name :bitbucket.addon.docker.uninstall))))
