# clj-qobuz

A Clojure library for using Qobuz

## Usage

Require useful namespaces

```Clojure
(require '[clj-qobuz.core :as core])
(require '[clj-qobuz.user :as user])
(require '[clj-qobuz.user :as artist])
```

Now you can search for an artist (for example):

```Clojure

clj-qobuz.core> (artist/search "mgmt" {:app-id "REDACTED" :app-secret "REDACTED"})
{:query "mgmt",
 :artists
 {:limit 1,
  :offset 0,
  :total 148958,
  :items
  [{:picture nil,
    :id 118680,
    :albums_count 36,
    :name "MGMT",
    :slug "mgmt"}
    ...]}}
```

I've cut the response here because this query returns a lot of
results. Notice that you have to supply your app ID and secret.

If you don't want to supply the ID and secret you can use the dynamic
variables `*app-id*`and `*app-secret*`.

```Clojure
clj-qobuz.core> (binding [*app-id* "REDACTED" *app-secret* "REDACTED"] (artist/search "mgmt"))
{:query "mgmt",
 :artists
 {:limit 1,
  :offset 0,
  :total 148958,
  :items
  [{:picture nil,
    :id 118680,
    :albums_count 36,
    :name "MGMT",
    :slug "mgmt"}
    ...]}}
```

You can also supply optional arguments in the options map.
Artist search supports
[limit](https://github.com/Qobuz/api-documentation/blob/master/endpoints/artist/search.md):

```Clojure

clj-qobuz.core> (binding [*app-id* "REDACTED" *app-secret* "REDACTED"]
                  (artist/search "mgmt" {:query-params {:limit 1}}))

{:query "mgmt",
 :artists
 {:limit 1,
  :offset 0,
  :total 148958,
  :items
  [{:id 118680,
    :picture nil,
    :slug "mgmt",
    :albums_count 36,
    :name "MGMT"}]}}
clj-qobuz.core>
```

Some requests need to have credentials, or give you more information
if you are signed in. Get the user object (I've cut out a lot of
extraneous info):

```Clojure

clj-qobuz.core> (email-login "your-email@domain.com" "password" {:app-id "REDACTED" :app-secret "REDACTED"})
{:user
 {:email "your-email@domain.com",
  :language_code "en",
  :store "GB-en",
  :zone "GB",
  :lastname "",
  :credential
  {},
  :externals {},
  :login "username",
  :country_code "GB",
  :firstname ""},
 :user_auth_token
 "auth-token-here"}
```

The token is the useful bit

```Clojure
clj-qobuz.core> (def token (:user_auth_token *1))
#'clj-qobuz.core/token
```

Now query with your user (I've cut a bunch of private output):
```Clojure
clj-qobuz.core> (binding [*app-id* "REDACTED" *app-secret* "REDACTED"]
                  (track/get-file-url "2275757" "5" {:token token}))
{:track_id 2275757,
 :duration 167,
 :sampling_rate 44.1,
 :bit_depth 16}
```

## License

Copyright © 2018 Audiogum

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
