(ns clj-qobuz.playlist
  (:require [clj-qobuz.core :as core])
  (:refer-clojure :exclude [get]))

(defn get
  [playlist-id & [options]]
  (core/call-qobuz "playlist" "get" {:playlist_id playlist-id} options))

(defn user-playlists
  "Get playlists for user.
  `options` can contain `:query-params` with the following keys:
   * :username
   * :user_id
   * :order"
  [& [options]]
  (core/call-qobuz "playlist" "getUserPlaylists" {} options))

(defn create
  "Create playlist.
  `options` can contain `:query-params` with the following keys:
  * :description
  * :is_public (1 == public)
  * :is_collaborative (1 == collaborative)
  * :track_ids
  * :album_id (initial album to add to the playlist)."
  [name & [options]]
  (core/call-qobuz "playlist" "create" {:name name} options))

;; See https://github.com/Qobuz/api-documentation/blob/master/endpoints/playlist/getFeatured.md
(defn featured-playlists
  "Get featured playlists.
  `listtype` must be one of `editor-picks` or `last-created`
  `options` can contain `:query-params` with the following keys:
  * :genre_ids list of genre ids"
  [listtype & [options]]
  (core/call-qobuz "playlist" "getFeatured" {:type listtype} options))
