(ns clj-qobuz.album
  (:require [clj-qobuz.core :as core])
  (:refer-clojure :exclude [get]))

(defn get
  [album-id & [options]]
  (core/call-qobuz "album" "get" {:album_id album-id} options))

;; See https://github.com/Qobuz/api-documentation/blob/master/endpoints/album/getFeatured.md
(defn featured-albums
  "Get featured albums.
  `listtype` must be one of `best-sellers`, `most-streamed`, `new-releases`, `press-awards`, `editor-picks`, `most-featured`
  `options` can contain `:query-params` with the following keys:
  * :genre_id genre to filter by"
  [listtype & [options]]
  (core/call-qobuz "album" "getFeatured" {:type listtype} options))
