(ns clj-qobuz.favorite
  (:require [clj-qobuz.core :as core])
  (:refer-clojure :exclude [get]))

(defn user-favorites
  "Get favorites for user.
  `options` can contain `:query-params` with the following keys:
   * :user_id
   * :type"
  [& [options]]
  (core/call-qobuz "favorite" "getUserFavorites" {} options))

(defn create
  "Create favorite
  `options` can contain `:query-params` with the following keys:
  * :artist_ids
  * :album_ids
  * :track_ids"
  [& [options]]
  (core/call-qobuz "favorite" "create" {} options))

(defn delete
  "Delete favorite
  `options` can contain `:query-params` with the following keys:
  * :artist_ids
  * :album_ids
  * :track_ids"
  [& [options]]
  (core/call-qobuz "favorite" "delete" {} options))
