(ns clj-qobuz.catalog
  (:require [clj-qobuz.core :as core])
  (:refer-clojure :exclude [count]))

(defn search
  "Search the qobuz catalog.
  Options can have `:query-params` with
  * `:type` - can be \"tracks\", \"albums\", \"artists\",
  \"articles\", \"playlists\" or \"focus\""
  [query & [options]]
  (core/call-qobuz "catalog" "search" {:query query} options))

(defn count
  [query & [options]]
  (core/call-qobuz "catalog" "count" {:query query} options))

(defn featured
  "Options can have `:query-params` with keys:
  * :genre_ids,
  * :limit,
  * :offset,
  * :type."
  [& [options]]
  (core/call-qobuz "catalog" "getFeatured" {} options))

(defn featured-types
  [& [options]]
  (core/call-qobuz "catalog" "getFeaturedTypes" {} options))
