(ns clj-qobuz.playlist
  (:require [clj-qobuz.core :as core])
  (:refer-clojure :exclude [get]))

(defn get
  [playlist-id & [options]]
  (core/call-qobuz "playlist" "get" {:playlist_id playlist-id} options))

(defn user-playlists
  "Get playlists for user.
  `options` can contain `:query-params` with the following keys:
   * :username
   * :user_id
   * :order"
  [& [options]]
  (core/call-qobuz "playlist" "getUserPlaylists" {} options))
