(ns analysis.symbol
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [comp.mui :as mui]
    [comp.table :refer [my-table]]
    [comp.input :refer [atom-input list-selector go-next go-prior]]
    [comp.key-listener :refer [key-shortcut-listener]]
    [api.get :refer [get-data]]
    [styles.ssymbol :refer [symbol-box instrument-name dropdowncontainer category tr td]])
  (:require-macros
      [cljss.core] ; Important - otherwise styles do not work.
      [devcards.core :as dc :refer [defcard defcard-rg]]))


; (def rolls (reagent/atom [1 2 3 4]))
; (def sorted-rolls (reagent.ratom/reaction (sort @rolls)))

;(def memo-search (memoize search-symbols))

(defn search
  "makes api request and does callback"
  [query category on-receive]
  (do
    (println "Search SENT: " query " category:" category)
    (get-data :unverse-search {:query query :type category :exchange "" :limit 10}
        (fn [result-rcvd]
          (do (println "Search RCVD: " result-rcvd)
              (on-receive result-rcvd))))))


(def categories [
  "Equity"
  "Corp"
  "Index"
  "List"
  "Curncy"
  "Comdty"
  ])

(defn results-table [results set-symbol]
  [:table
     [:thead
      [:tr [:td "Symbol"] [:td "Name"] [:td "Category"] [:td "Exch"]]
      ]
    [:tbody
    (for [r results]
         ^{:key (:symbol r)}
          [tr {:on-click #(set-symbol (:symbol r) (:name r))}
              [td {:width "3cm"} (:symbol r)]
              [td {:width "5cm"} (:name r)]
              [td {:width "2cm"} (:category r)]
              [td {:width "1cm"} (:exchange r)]])
     ]]
  )

(defn results-categories [active-category set-category]
  [:<>
     ; Empty Category = All Categories
     [category {:is-selected (= active-category "")
                :on-click #(set-category "")} "All"]
     (for [c categories]
        ^{:key c}
        [category {:is-selected (= active-category c)
                   :on-click #(set-category c)} c])])

(defn search-box [category results set-category set-symbol]
  [:<>
    [results-categories category set-category]
    [results-table results set-symbol]])


(defn dropdown-view
  "dropdown div with category filter and search results"
  [category results set-symbol set-category]
  [dropdowncontainer
      [search-box category results set-category set-symbol]
    ])

(defn input-symbol [symbol name searchq category results searching? set-symbol set-category set-query]
  (println "input-symbol symbol" symbol "searchq" searchq "category" category)
  [:<> ; div ; {:style {:position "relative" :display "inline-block"}}
    ^{:show-dropdown? (not= symbol searchq)}
     [symbol-box ; .form-control
        {:placeholder "symbol/name"
         :type        "text"
         :on-change   #(set-query (.-target.value %))
         :on-key-up   #(when (= (.-which %) 13)
                         (when-let [sym (first results)]
                           (set-symbol (:symbol sym) (:name sym))
                           ))
         :value       (if (nil? searchq) "" searchq)
         :show-dropdown? (not= symbol searchq)
         }]
         [instrument-name  name]

     (when searching?
           [dropdown-view category results set-symbol set-category])
  ]
  )


(defn symbol-component [state]
  (r/with-let
     [search-state (r/atom {
          :category ""
          :searchq ""
          :searching? false
          :last-searchq ""
          :last-category ""
          :results []
       })
      set-result (fn [results] (swap! search-state assoc :results results))
      set-category (fn [c] (swap! search-state assoc :category c))
      set-symbol (fn [s n] (println "set-symbol to: [" s "]")
                         (swap! state assoc :symbol s :name n)
                         (swap! state dissoc :portfolio)
                         (swap! search-state assoc :searching? false
                                                   :results []
                                                   :searchq s
                                                   )
                         )
      set-query (fn [q] (swap! search-state assoc :searchq q :searching? true))
      watch-symbol (r/track! (fn []
        (do
          ;(println "watch symbol" (:symbol @state) " searchq" (:searchq @search-state) )
          (when  ; (not= (compare (:symbol @state) (:searchq @search-state)) 0)
                (not (:searching? @search-state))
                (println "Symbol-Box: symbol externally set to: " (:symbol @state))
                (swap! search-state assoc :searchq (:symbol @state))
                ))))
      watch (r/track! (fn []
        (do
          ;(println "watch symbol" (:symbol @state) " searchq" (:searchq @search-state) )
          (when  ;
                (and (:searching? @search-state)
                     (or (not= (compare (:last-searchq @search-state) (:searchq @search-state)) 0)
                         (not= (compare (:last-category @search-state) (:category @search-state)) 0)))
                (do  (swap! search-state assoc :last-searchq (:searchq @search-state)
                                               :last-category (:category @search-state))
                     (search (:searchq @search-state) (:category @search-state) set-result)))))
                  )

    ]
      (let [symbol (:symbol @state)
            name (:name @state)
            searchq (:searchq @search-state)
            category (:category @search-state)
            results (:results @search-state)
            searching? (:searching? @search-state)
      ]
      [input-symbol symbol name searchq category results searching? set-symbol set-category set-query]
      )
    (finally (do
       (r/dispose! watch)
       (r/dispose! watch-symbol))
    )))

;; DEV-CARDS

(defonce layout-state (r/atom {
    :category "Equity"
    :results [{:symbol "DAX Index" :name "dax??"}
               {:symbol "CAI AV Equity" :name "CA Immo"}]
  }))

(defn set-category-layout [c]
  (swap! layout-state assoc :category c))

(defn set-symbol-layout [c n]
  (swap! layout-state assoc :symbol c :name n))


(defcard-rg search-box
   "#layout of the search-box
   ##works with static data
   "
  (fn []
   [:<>
    [search-box (:category @layout-state)
                (:results @layout-state)
                set-category-layout
                set-symbol-layout]])
  layout-state
  {:inspect-data true :history true})




(def mega-state (r/atom {:symbol nil}))

(defcard-rg component-test
    "enter symbol (and press enter)"
    (fn []
    [:<>
      [:div {:style {:background-color "orange"}}
        [:button {:on-click #(swap! mega-state assoc :symbol "MSFT US Equity")} "MSFT"]
        [:button {:on-click #(swap! mega-state assoc :symbol "CAI AV Equity")} "CAI"]]
        [symbol-component mega-state]
        [:p "the real mega symbol: " (:symbol @mega-state)]
        ])
    mega-state
    {:inspect-data true :history true}
    )
