(ns analysis.test
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [comp.mui :as mui]
    [comp.input :refer [atom-input list-selector go-next go-prior]]
    [comp.key-listener :refer [key-shortcut-listener]])
  (:require-macros
      ;[cljs.test :refer [is testing]]
      [devcards.core :as dc :refer [defcard defcard-rg]]))

      ;(key/bind! "right" ::next-symbol-right #(js/console.log "key right pressed"))
      ;(key/unbind! "ctrl-right" ::next-symbol)
      ;(key/unbind-all!)

      (defn symbol-selector
        "callback on enter press. symbol bound to an external atom"
        [symbol action]
        (let [temporary-symbol (r/atom "")]
          (fn [symbol]
            [:input {:type "text"
                     :value @temporary-symbol
                     :on-change #(reset! temporary-symbol (-> % .-target .-value))
                     :on-key-press   (fn [e]
                                           (let [enter? (= 13 (.-charCode e))
                                                 ;x (println "entered: " (.-charCode e))
                                                 ]
                                             (when enter?
                                               (reset! symbol @temporary-symbol)
                                               (action @symbol)
                                               )))
             }])
        ))



        (defn select-symbol-raw [symbol-atom action1]
          (let [symbol-instrument (r/atom "")
                action (fn [symbol] (do (reset! symbol-atom symbol)
                                        (action1 symbol)))
                set-symbol (fn [symbol] (do (reset! symbol-instrument symbol)
                                             (action symbol)))
                ]
            (fn [action1]
              [:div
                 [:span "Instrument: " [symbol-selector symbol-instrument action]]
                 ;[portfolio-selector symbol-instrument action]
                 [:span "Showing: " @symbol-instrument]
              ])))


        (defn select-symbol [action]
              (let [symbol-atom (r/atom "")]
                (fn [action]
                  [select-symbol-raw symbol-atom action]
                  )))


                  (defonce demo-symbol- (r/atom nil))
                  (defcard-rg symbol-select
                    "enter symbol (and press enter)"
                    (fn []
                      [:<>
                        [symbol-selector demo-symbol- #(.log js/console "You selected: " %)]
                        [:p (str "SYMBOL IS " @demo-symbol-)]])
                    demo-symbol-
                    {:inspect-data true :history true})
