(ns api.rest
  (:require
    [goog.string :as string]
    [goog.uri.utils :as uri]
    [api.my-host :refer [create-url]]
    [helper.myutil :refer [log]]))

;; Make URL GET requests that return JSON data.

(defn get-url-web
  "gets an url from the web
  response is expected to be in json format"
  [url success failure]
  (do
    (println "rest/get SENT" url)
    (-> (js/fetch url)
       (.then (fn [r] (do (println "rest/get RCVD" url) (identity r))))
       (.then (fn [r] (.json r)))
       (.then (fn [r] (js->clj r :keywordize-keys true)))
       (.then (fn [r] (success r)))
       (.catch (fn [r] (do
         (let [rclj (js->clj r :keywordize-keys true)]
           (println "rest/get ERR " url rclj)
           ;(println rclj)
           (when (not (nil? failure)) (failure r)) )))) )))

(defn append-params [path m]
   "adds url-encoded query parameters to an url"
   (uri/appendParamsFromMap path (clj->js m)))

(defn get-url-internal
  "gets data from a partial url from our api-server
   the prefix (http/https) and ip:port is prefixed via my-host.create-url
   optional: query params are are in the [m] parameter which has to be a map
  "
  ([partial-url success]
    (get-url-internal partial-url success nil))
  ([partial-url success failure]
    (get-url-web (create-url partial-url) success failure))
  ([partial-url m success failure]
    (get-url-web (append-params (create-url partial-url) m) success failure)))
