(ns app.quant.routes
  (:require-macros [secretary.core :refer [defroute]])
  (:import goog.history.Html5History)
  (:require
    [secretary.core :as secretary]
    [goog.events :as events]
    [goog.history.EventType :as EventType]
    [reagent.core :as reagent]

    [app.quant.db :refer [set-current-page app-state]]
    [app.quant.views.menu  :as menu]
    [app.quant.views.home]

    [universe.core]

    ;[seasonality.instsim :as seasonality-instsim]
    [seasonality.listsim :as seasonality-listsim]
    [seasonality.precalc :refer [seasonality-precalc-page]]
    [financials.core :as financials]
    [financials.ratio :as ratio]
    [analysis.app]
 ))

(defn hook-browser-navigation! []
  (doto (Html5History.)
    (events/listen
      EventType/NAVIGATE
      (fn [event]
        (secretary/dispatch! (.-token event))))
    (.setEnabled true)))

; https://github.com/clj-commons/secretary#basic-routing-and-dispatch

(defn init-routes []
  (secretary/set-config! :prefix "#")

  ;; HOME
  (defroute "/" []
    (set-current-page :home))

  ;; Universe
  (defroute "/universe" []
     (set-current-page :universe))


  (defroute "/analysis" [query-params]
    (let [strategy (:strategy query-params)
          symbol (:symbol query-params)]
      (do (if (not (nil? strategy))
              (swap! analysis.app/state-analysis assoc :strategy strategy))
          (if (not (nil? symbol))
              (swap! analysis.app/state-analysis assoc :symbol symbol :name "unknown"))
          (set-current-page :analysis))))

  ;(defroute "/indexdetail/:symbol" [symbol]
  ;   (do (swap! index/app-state assoc :symbol symbol)
  ;       (swap! index/app-state assoc :instrument nil)
  ;       (set-current-page :detail )))

  ;; SEASONAL
  (defroute "/seasonal/simulate-list" []
    (set-current-page :seasonal-simulate-list))
  (defroute "/seasonal/precalc" []
    (set-current-page :seasonal-precalc))

  ;; FUNDAMENTAL
  (defroute "/financials" []
    (set-current-page :financials))
  (defroute "/ratio" []
    (set-current-page :ratio))

  (hook-browser-navigation!))


(def myroutes {
  :home {:component app.quant.views.home/home :menu "home"}

  ; Universe
  :universe {:component universe.core/universe-page :menu "Universe"}
  ; :detail-index {:component index/details-page :menu "details"}

  ; Instrument Analytics
  :analysis {:component analysis.app/analysis-app} ; NO MENU

  ; Seasonal
  :seasonal-simulate-list {:component seasonality-listsim/sim-app :menu "s-instsim"}
  :seasonal-precalc {:component seasonality-precalc-page} ; NO MENU

   ; Fundamental
   :ratio {:component ratio/ratio-page :menu "ratio"}
})

(defn myroutes-new []
  (fn []
   (let [page-key (:page @app-state)
         page-key (if (nil? page-key) :home page-key)
         page (page-key myroutes)
         menu-name (:menu page)
         ;_ (println "menu is: " menu-name)
         component (:component page)
         ]
      [:<>
        (when (not (nil? menu-name))
            [menu/menu menu-name])
        [component]
      ])))
