(ns app.quant.views.menu
  (:require
    [reagent.core :refer [atom]]
    [comp.mui :as mui]
    ))

(defn menu
  "main menu of our app"
  [name]
  [mui/paper {:square true
              :style  {:background-color mui/secondary
                       ;; :text-align       :center
                       :padding          "1em 2em 1em 2em"}}

   [mui/grid {:container   true
              :align-items :center
              :spacing     16
              :xs 12}

    [mui/grid {:item true :xs 1}
     [mui/typography {:variant :title
                      :style   {:color   :white}}
      name]]

  ;  [mui/grid {:item true :xs 1}
  ;   [mui/typography {:variant :title
  ;                    :style   {:color   :white}}
  ;    [:a {:href "#/help"} "help"]]]

    [mui/grid {:item true :xs 1}
     [mui/typography {:variant :title
                        :style   {:color   :white}}
        [:a {:href "#/universe"} "Universe"]]]

    [mui/grid {:item true :xs 1}
     [mui/typography {:variant :title
                      :style   {:color   :white}}
      [:a {:href "#/analysis"} "Analysis"]]]

    [mui/grid {:item true :xs 1}
     [mui/typography {:variant :title
                      :style   {:color   :white}}
      [:a {:href "#/seasonal/simulate-list"} "sim-list"]]]


    [mui/grid {:item true :xs 1}
     [mui/typography {:variant :title
                      :style   {:color   :white}}
      [:a {:href "#/financials"} "financials"]]]

    [mui/grid {:item true :xs 1}
     [mui/typography {:variant :title
                      :style   {:color   :white}}
      [:a {:href "#/ratio"} "ratio"]]]

      [mui/grid {:item true :xs 1}
       [mui/typography {:variant :title
                        :style   {:color   :white}}
        [:a {:href "#/seasonal/precalc"} "seasonal-recalc"]]]


    ]
   ])
