(ns bloomberg.data.bond
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]
    [clj-time.format :as fmt]
    [bloomberg.request.reference :refer [bloomberg-get-reference-data]]
    [bloomberg.request.date :refer [str-2-date]]
    ))

(defn preprocess-bond-response [response]
  (let [instrument (first response) ]
    (-> instrument
        (clojure.set/rename-keys {:security :symbol
                                  :NAME :name
                                  })
        (assoc :category "Corp")
        (update :MATURITY str-2-date)
        (update :LISTED_EXCH  #(map :ExchangeCode %))
        )))


(defn get-bond-info
  "gets bond descriptive data"
  [symbol]
  (-> { :symbol symbol
        :field ["NAME"
                "MARKET_STATUS"
                "QUOTED_CRNCY"
                "DES_NOTES"
                "CNTRY_OF_INCORPORATION"
                "SECURITY_TYP"
                "ID_ISIN"
                ;ID_CUSIP_ID_NUM
                ;ID_WERTPAPIER;ID_SEDOL1
                ;ID_COMMON
                "ID_BB_GLOBAL"
                "ID_BB_COMPANY"
                "ID_BB_PRIM_SECURITY_FLAG"
                "LISTED_EXCH" ; gives back an array of all exchanges
                "CRNCY"

                "COUPON"
                "MATURITY"
                "COLLAT_TYP"
                "CPN_TYP"
                "MTY_TYP"
                ]}
        (bloomberg-get-reference-data)
        (preprocess-bond-response)
        ))

(comment

  (let [ed (get-bond-info "AT2448856 Corp")]
    (println "equity desc full: " ed))

)
