(ns bloomberg.data.equity
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]
    [clj-time.format :as fmt]
    [bloomberg.request.reference :refer [bloomberg-get-reference-data]]
    [bloomberg.request.date :refer [str-2-date]]
    ))

(defn preprocess-equity-response [response]
  (let [instrument (first response) ]
    (-> instrument
        (clojure.set/rename-keys {:security :symbol
                                  :INDUSTRY_SECTOR :sector
                                  :INDUSTRY_GROUP :industry
                                  :INDUSTRY_SUBGROUP :subindustry
                                  :NAME :name
                                  :CIE_DES_BULK :description
                                  })
        (assoc :category "Equity")
        (update :description  #(str/join " " (map :CompanyDescription %)))
        )))


(defn get-equity-descriptive
  "gets equity descriptive data"
  [symbol]
  (-> { :symbol symbol
        :field ["NAME"
                "MARKET_STATUS"
                "FUNDAMENTALS_TICKER" ; ticker used for fundamental reports
                ;"HISTORY_START_DT" only for index.
                "QUOTED_CRNCY"
                "INDUSTRY_SECTOR" "INDUSTRY_GROUP" "INDUSTRY_SUBGROUP"
                "CIE_DES_BULK" "DES_NOTES" "COMPANY_WEB_ADDRESS"
                "CNTRY_OF_INCORPORATION"
                "SECURITY_TYP"
                "EQY_PRIM_EXCH"
                "ID_BB_PRIM_SECURITY_FLAG"
                ;"LISTED_EXCH" ; gives back an array of all exchanges
                "CRNCY"
                "EQY_SH_OUT"
                "EQY_FLOAT"
                "EQY_INST_SH_HELD"    ; divide by 1 mio
                ; ID_ISIN
                ;ID_CUSIP_ID_NUM
                ;ID_WERTPAPIER;ID_SEDOL1
                ;ID_COMMON
                ;ID_BB_GLOBAL
                ;ID_BB_COMPANY
                ; "RELATED_EQUITIES"  ;All Exchanges the stock is listed on
                "BLOOMBERG_PEERS"
                "EQY_INDX_LIST"
                ;COMPANY_EXEC_OFFICERS
                ;COMPANY_BOARD_MEMBERS
                ;COMPANY_ADDRESS
                "EQY_EMPLOYEE_NUM"
                "EQY_INIT_PO_DT"
                "EQY_INIT_PO_TYP"
                "EQY_INIT_PO_SH_OFFER"
                "EQY_INIT_PO_SH_PX"
                "EQY_SPLIT_ADJ_INIT_PO_PX"
                "EQY_INIT_PO_LEAD_MGR;"
                "EQY_IPO_LOCKUP_DT"]}
        (bloomberg-get-reference-data)
        (preprocess-equity-response)
        ))

(comment
  (let [ed (get-equity-descriptive "UQA AV Equity")]
    (println "equity desc full: " ed)
    (println "description: " (:description ed)  )
    (map :CompanyDescription (:description ed) )
   )
)
