(ns bloomberg.data.report-individual
  (:require
     [clj-time.core :as t]
     [clojure.string :as str]
     [clj-time.format :as fmt]
     [bloomberg.request.reference :refer [bloomberg-get-reference-data]]
     [bloomberg.request.date :refer [str-2-date]]
   ))


(defn end-str-to-date [report]
  (let [fields (:fields report)
        s (:LATEST_PERIOD_END_DT_FULL_RECORD fields)
        d (if (or (nil? s) (str/blank? s)) nil (str-2-date s) )
        ]
    (if (nil? d)
        report
        (assoc-in report [:fields :LATEST_PERIOD_END_DT_FULL_RECORD] d))
    ))


(defn wrap-report-header- [fields symbol report-name]
  {:symbol symbol :period report-name :fields (dissoc  fields :security)})


(defn get-one-report [symbol report-name fields]
  (let [[year period]  (str/split report-name #":")
         field (-> (map name fields)
                   (conj "LATEST_PERIOD_END_DT_FULL_RECORD")
                   (vec))]
    (-> {:symbol symbol
         :field field
         :override [(str "EQY_FUND_YEAR=" year) (str "EQY_FUND_PER=" period)]}
        (bloomberg-get-reference-data)
        (first)
        (wrap-report-header- symbol report-name )
        (assoc :savedate (t/now))
        (end-str-to-date)
        )))



(comment


  (get-one-report "MCD UN Equity" "2017:Y" [ :EBIT :BS_SH_OUT :LATEST_PERIOD_END_DT_FULL_RECORD])

  (get-one-report "IIA AV Equity" "1998:Y" [:BS_SHAREHOLDER_EQY_ENDING_PERIOD
                                            :BS_TOT_ASSET
                                            :SALES_REV_TURN
                                            :ANNOUNCEMENT_DT
                                            ])

  (get-one-report "MSFT US Equity" "1998:Y" [:BS_SHAREHOLDER_EQY_ENDING_PERIOD
                                             :BS_TOT_ASSET
                                             :SALES_REV_TURN
                                             :ANNOUNCEMENT_DT
                                             ; :LATEST_PERIOD_END_DT_FULL_RECORD
                                             ])




  (wrap-report-header- {:rev 345 :ebit 3 :security "bongo"} "MO Equity" "2018:A")

  )
