(ns bloomberg.data.report-summary
  (:require
    [clj-time.core :as t]
    [clj-time.format :as fmt]
    [bloomberg.request.reference :refer [bloomberg-get-reference-data]]
    [bloomberg.request.date :refer [str-2-date]]
    ))

(defn preprocess-ern-ann-dt [list]
  ;(println list)
  (map #( update % :EarningsAnnouncementDate str-2-date) (vec list)))

(defn preprocess-financial-summary [summary]
  (->  summary
       (clojure.set/rename-keys {:security :symbol})
       (update :EXPECTED_REPORT_DT str-2-date)
       (update :ERN_ANN_DT_AND_PER preprocess-ern-ann-dt) ))


(defn calc? [data func]
  (if (or (nil? data)
          (= (count data) 0))
    nil
    (func (first data ) )))


(defn get-financial-summary
  [symbol]
    (-> { :symbol symbol
          :field ["EXPECTED_REPORT_DT" "ERN_ANN_DT_AND_PER" "EQY_FUND_CRNCY" "EQY_FUND_IND"]}
        (bloomberg-get-reference-data)
        (calc? preprocess-financial-summary)))


(comment

  ; FINANCIAL REPORTS

  (fmt/parse (:date fmt/formatters) (subs "2018-10-23T00:00:00" 0 10))
  (fmt/parse "2018-10-23T00:00:00", (fmt/formatter "yyyy-M-d H:m:s"))
  (str-2-date "2018-10-23T00:00:00")


  (def test-financial-summary {:security "MCD UN Equity",
                               :EXPECTED_REPORT_DT "2018-10-23T00:00:00",
                               :ERN_ANN_DT_AND_PER '({:EarningsAnnouncementDate "2018-07-26T00:00:00", :EarningsYearandPeriod "2018:C2"}
                                                      {:EarningsAnnouncementDate "2018-07-26T00:00:00", :EarningsYearandPeriod "2018:Q2"}
                                                      {:EarningsAnnouncementDate "2018-04-30T00:00:00", :EarningsYearandPeriod "2018:C1"}
                                                      ) } )

  (preprocess-financial-summary test-financial-summary )

  (get-financial-summary "AFSI UW Equity")
  (get-financial-summary "MCD UN Equity")

)
