(ns bloomberg.request.request
  (:require
    [clojure.string :as str]
    [clojure.set :as set]
    [clojure.java.io :as io]
    [clojure.java.shell :only [sh]]
    [cheshire.core :refer :all] ; JSON Encoding
    [clj-time.core :as t]
    [clj-time.format :as fmt]
    ))


(defn extract-fields  ; OLD REMOVE
  "fields is array of array; return map of keyword/value"
  [fields]
  (let [ remove-spaces (fn [str] (clojure.string/replace str #" " ""))
         field-rows (map #( assoc {}  (keyword (remove-spaces (:name %))) (:Data %) )  fields)]
    (apply merge field-rows)
  ))

(defn update-values
  "replace fields in a map with custom function argument"
  [m f & args]
  (into {} (for [[k v] m] [k (apply f v args)])))
;(update-values {:a 1 :b 2 :c 3} inc)

(defn extract-fields-recursive
    "fields is array of array; return map of keyword/value"
    [fields]
    (let [remove-spaces (fn [str] (clojure.string/replace str #" " ""))
          field-rows (map #( assoc {}  (keyword (remove-spaces (:name %))) (:Data %) )  (:fields fields) )
          drilldown-if-needed (fn [field]  ( if (vector? field)
            (do ;(println "recursive field: " field)
                (map extract-fields-recursive field))
             field))
          field-map (apply merge field-rows)]
        (update-values field-map drilldown-if-needed )
    ))

(defn extract-rows
  [json]
  ;(println "**JSON**" json)
  (map extract-fields-recursive json)
  ;(map extract-fields-recursive (:rows json))
  )


(defn extract-bloomberg-response
  "parses bloomberg response (string) to list of maps"
  [response]
  (let [ json (cheshire.core/parse-string (:out response) true)
    rows (map #( extract-fields-recursive %) (:rows json))]
    rows))


(def bbclient-dir "./resources/BBClient")


(defn bloomberg-request-data
  "request data from bloomberg"
  [request-type params]
  (let [args (concat ["mono" "BBClient.exe" "-m" request-type] params [:dir bbclient-dir])
        response (apply clojure.java.shell/sh args)
        xx (if (> 0 (:exit response))
              (do (println "BB exit code: " (:exit response))
                  (println "BB error: " (:err response))))
        ;xx (println "bb response RCVD: " (:out response))
        json (cheshire.core/parse-string (:out response) true)
        ;xx (println json)
        ]
    (if (:Error json)
      (do (println "Bloomberg Request Error: " (:ErrorMessage json))
          nil)
      (extract-rows json))))






(comment ;  *****************************************************************************

; test parsing of bloomberg response data

  ( -> "resources/bbtest/reference.json"
       ;"resources/bbtest/portfolio.json"
    (slurp)
    (cheshire.core/parse-string true))


  (-> ;"resources/bbtest/reference.json"
      "resources/bbtest/portfolio.json"
      (slurp)
      (hash-map :out)

    ;  (extract-bloomberg-response)
      ;(first)
      )

  (println (cheshire.core/parse-string (slurp "resources/bbtest/reference.json") true))

(hash-map :a "f")

;  (println (first (extract-bloomberg-response {:o)))

; test executing BBClient
  (clojure.java.shell/sh "pwd")
  (clojure.java.shell/sh "ls" "-alfg")
  (def test (clojure.java.shell/sh "mono" "BBClient.exe" "-m" "SearchSymbol" "-q" "DAX" :dir bbclient-dir ))
  (println test)

; test BB Reference Request
  (bloomberg-request-data "Reference" ["-s" "BP/ US Equity;ATX Index" "-f" "NAME;PX_LAST"])
  (bloomberg-request-data "SearchSymbol" ["-q" "DAX"])
  (bloomberg-request-data "History" ["-s" "DAX Index"
                                     "-f" "PX_OPEN;PX_HIGH;PX_LOW;PX_LAST;PX_VOLUME"
                                     "-t" "20190101" "20190130"
                                     "-p" "DAILY" "ACTUAL"])


  (println (first (extract-bloomberg-response {:out (slurp "resources/bbtest/portfolio.json") })))





  ) ; ******************************************************************************
