(ns bloomberg.request.series
  (:require
    [clj-time.core :as t]
    [clj-time.format :as fmt]
    [bloomberg.request.request :refer [bloomberg-request-data]]
    [bloomberg.request.date :refer [str-2-date]]
    ))

(defn bloomberg-get-series
  "downloads timeseries from bloomberg for a symbol"
  [date-from date-to symbol]
  (->> ["-s" symbol
        ;"-d" "../../../DAILY/" ; relative to BBClient dir
        "-f" "PX_OPEN" "PX_HIGH" "PX_LOW" "PX_LAST" "PX_VOLUME"
        "-t" date-from date-to
        "-p" "DAILY" "ACTUAL"]
        (bloomberg-request-data "History")
        ;(println "received: " )
        (map #(update % :date str-2-date))
        ))



(comment
  (str-2-date "2012-06-30T00:00:00")

  (bloomberg-get-series "20190101" "20190113" "DAX Index")

  (bloomberg-get-series "20190905" "20191231" "AN288649 Corp")
  (bloomberg-get-series "19500101" "20201231" "LW1230900 Corp")


  )
