(ns cleaning.category
  (:require
    [mongo.db :refer [db]]
    [monger.collection :as mc]
    [data.equity-symbol]
  ))

(defn instruments-no-category []
  (mc/find-maps db "instruments" { :category nil } {:symbol 1 :NAME 1}))

(defn update-category [instrument]
  (let [category (data.equity-symbol/separate-category instrument)]
     (if-not
      (nil? category)
       (do (println "updating "(:symbol instrument) " - " category)
           (mc/update db "instruments" {:symbol (:symbol instrument)} {:$set category} {:upsert false})
         )
       (println "no category found for: " (:symbol instrument))
      )))

(defn calculate-categories
  "Category is: 'Index' 'Equity' 'Curncy' 'List', etc.
   To get Instruments by category it is crucial that each instrument has a category.
   This function calculates missing Categories."
  []
  (let [instruments (->> (instruments-no-category)
                         (remove #(nil? %))
                         (remove #(nil? (:symbol %))))
        ;xx (println instruments)
        ;categories   (map data.equity-symbol/separate-category instruments)
        ;xx (println categories)
        ;          (filter #(in? ["Equity" "Index" "Curncy"] (:category %)))
        ]
    (println "# Instruments without category: " (count instruments))
    (doall (map (partial update-category db) instruments))
    ;(map #(println "inst: " %) instruments)
    (println "Saving Categories.. DONE!")
    ))

(defn equities-no-exchange []
  (mc/find-maps db "instruments" { :category "Equity" :exchange nil } {:symbol 1 :NAME 1}))


(defn calculate-categories-equities
  "Category is: 'Index' 'Equity' 'Curncy' 'List', etc.
   To get Instruments by category it is crucial that each instrument has a category.
   This function calculates missing Categories."
  []
  (let [instruments (->> (equities-no-exchange)
                         (remove #(nil? %))
                         (remove #(nil? (:symbol %))))
        ;xx (println instruments)
        ;categories   (map data.equity-symbol/separate-category instruments)
        ;xx (println categories)
        ;          (filter #(in? ["Equity" "Index" "Curncy"] (:category %)))
        ]
    (println "# Instruments without category: " (count instruments))
    (doall (map update-category instruments))
    ;(map #(println "inst: " %) instruments)
    (println "Saving Categories.. DONE!")
    ))


(comment ; ******************************************************************

(defn rename-NAME []
  (mc/update db "instruments" {:NAME {:$ne nil}} {:$rename {:NAME :name}} {:multi true}))
(rename-NAME)



  ; Calculate Category for instruments that do not have a category.

  (count (instruments-no-category ))

  (nth (instruments-no-category ) 0)

  (update-category  {:symbol "AIF-U CN Equity"})

  (calculate-categories )

  (calculate-categories-equities )

  ) ; ******************************************************************
