(ns cleaning.csv-series-to-mongo
  (:require
    [series.csv]
    [mongo.series :refer [load-series save-series]]
  ))

(defn tap [f v]
  (println (f v))
   v)

(defn csv-to-mongo [symbol]
  (->> symbol
      (tap identity)
      (series.csv/load-series)
      ;(println)
      (save-series symbol)
      ))


(defn import-all-csv-to-mongo []
    (->> (series.csv/symbols-with-timeseries)
        (tap count)
        (map csv-to-mongo)
    )
  )


(comment
  (csv-to-mongo "DAX Index")
  (csv-to-mongo "UQA AV Equity")

  (import-all-csv-to-mongo)
)
