(ns cleaning.reports-old
  (:require
    [clj-time.core :as t]
    [clj-time.format :as fmt]                               ; to sanitize report release-date
    [monger.collection :as mc]
    [clojure.reflect :as re]
    [mongo.db :refer [db]]
    ))

(defn remove-old-reports-all-symbols
  "remove old annual reports (save-date is type-of string)"
  [symbol]
  (let [mongo-result (mc/remove db "reports" {
                                              :type     "A"
                                              :savedate {:$type 2}
                                              })]
    {:reports-deleted (.getN mongo-result)}))


(defn remove-old-reports
  "remove old annual reports (save-date is type-of string)"
  [symbol]
  (let [mongo-result (mc/remove db "reports" {
                                              :symbol   symbol
                                              :type     "A"
                                              :savedate {:$type 2}
                                              })]
    {:reports-deleted (.getN mongo-result)}))

(defn remove-old-reports-date
  "remove old annual reports (save-date is type-of string)"
  [symbol]
  (let [mongo-result (mc/remove db "reports" {
                                              :symbol   symbol
                                              :type     "A"
                                              :savedate {:$lte (t/date-time 2019 01 07)}
                                              })]
    {:reports-deleted (.getN mongo-result)}))


(comment

  (remove-old-reports-all-symbols "")
  (remove-old-reports "LHA GY Equity")
  (remove-old-reports-date "MSFT US Equity")

  (println r)

  ; reflect object that is returned by monger
  (re/reflect r)

  (.getN r)

  )
