(ns cleaning.series
  (:require
    [clj-time.core :as t]
    [clojure.tools.logging :refer [info]]
    [mongo.series :refer [load-series load-series-partial]]
  ))


(defn one+ [expressions]
   (let [s (some true? expressions)]
     (if (nil? s) false true)))


(defn fields-missing [bar]
  (one+ [(nil? (:date bar))
         (nil? (:close bar))
         (nil? (:open bar))
         (nil? (:high bar))
         (nil? (:low bar))
         (nil? (:volume bar))
        ]))


(defn ok [bar]
  (let [missing (fields-missing bar)
       ]
    (not missing)))


(defn ok-print [bar]
  (let [result (ok bar)]
    (if (not result)
        (info "bad: " bar)
    )
    result))


(defn check [series]
    (let [result (map ok-print series)
         bad-count (count (filter false? result))]
    (println "series size: " (count series) " bad: " bad-count)
    ))

(comment
  (one+ [false true])
  (one+ [false false])

  (nil? (:date {:open 3 :close 4 :date 33}))

  (check [
    {:x 3 }
    {:open 3 :close 4 :datex 33}
    {:open 5 :close 6 :high 3 :low 5 :volume 100 :date 34}
    ])

  ; load timeseries, and split adjust it
  (let [symbol "BP/ LN Equity"
               ;"IIA AV Equity"
       ]
       (-> symbol
           (load-series)
           ;(load-series-partial (-> 30 t/days t/ago) (t/now))
          ; (load-series-partial (t/date-time 1998 1 1) (t/date-time 1998 1 4))
           (check)
           ;(println)
         )
       (println "check complete"))

)
