(ns comp.combo
  (:require
    [thi.ng.strf.core :as f]
    [reagent.core  :as r]
    [devcards.core])
  (:require-macros
      ;[cljs.test :refer [is testing]]
      [devcards.core :as dc :refer [defcard defcard-rg]]))


(defn index-of [col item]
  (let [found-index (first (map first (filter #(= (second %) item)
                               (map-indexed vector col))))
        found-index (if (nil? found-index) -1 found-index)
        ;_ (println "found index: " found-index " item:" item " coll:" col)
        ]
    found-index))

(defn combo
  "combobox pure function [val list action]
   No Atoms involved."
   ; Expects String as input
  ([val list action]
       [:select {:on-change #(action (.. % -target -value))
                 :value (if (nil? val) "" val)}
                (when list (map-indexed (fn [idx item]
                  [:option {:key idx :value item} item]) list))])
  ; Display a property of the map
  ; Since the value cannot be an object, we bind via index.
  ([val list display action]
       [:select {
         :value (if (nil? val) "" (index-of list val))
         :on-change #(do ;(println "change:" (.. % -target -value) )
                                  ;(action (.. % -target -value))
                                  (action (nth list (int (.. % -target -value))))
                                  )}
          (when list (map-indexed (fn [idx item]
             [:option {:key idx :value idx} (display item)]) list))]))



(defn go-next [val list action]
  (let [new-index (inc (.indexOf list val))
        new-index (if (= new-index (count list)) 0 new-index)
        new-value (nth list new-index)]
    (action new-value)))

(defn go-prior [val list action]
  (let [new-index (dec (.indexOf list val))
        new-index (if (< new-index 0 ) (- (count list) 1) new-index)
        new-value (nth list new-index)]
    (action new-value)))

; DEV-CARDS

(def demolist ["andreas" "florian" "willy" "peter" "bitcoin"])
(def demosymbol (r/atom "peter"))
(defn set-symbol [s]
    (println "list2 symbol changed to: " s)
    (reset! demosymbol s))

(defcard-rg combo-demo-simple
   "a simple combobox (with events)"
   (fn [][:<>
      [combo @demosymbol demolist  set-symbol]
      [:button {:on-click #(go-prior @demosymbol demolist set-symbol)} "prior"]
      [:button {:on-click #(go-next @demosymbol demolist set-symbol)} "next"]])
   demosymbol
   {:inspect-data true :history true})



(def demolist2 [{:name "andreas" :age 35} {:name "florian" :age 43} {:name "willy" :age 10}
                {:name "peter" :age 100}  {:name "bitcoin" :age 11}])
(def demosymbol2 (r/atom {:name "bitcoin" :age 11}))
(defn set-symbol2 [s]
   (println "list2 symbol changed to: " s)
   (reset! demosymbol2 s))

(defcard-rg combo-demo-maps
  "combo bound to seq of maps"
  (fn []
    [:<>
       [combo @demosymbol2 demolist2 :name set-symbol2]
       [:button {:on-click #(go-prior @demosymbol2 demolist2 set-symbol2)} "prior"]
       [:button {:on-click #(go-next @demosymbol2 demolist2 set-symbol2)} "next"]
       [:p "name is:" (:name @demosymbol2)]]
       )
  demosymbol2
  {:inspect-data true :history true})
